/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.data.statistics.BoxAndWhiskerXYDataset;
import org.jfree.data.xy.XYDataset;

public class BoxAndWhiskerXYToolTipGenerator
extends StandardXYToolTipGenerator
implements XYToolTipGenerator,
Cloneable,
Serializable {
    private static final long serialVersionUID = -2648775791161459710L;
    public static final String DEFAULT_TOOL_TIP_FORMAT = "X: {1} Mean: {2} Median: {3} Min: {4} Max: {5} Q1: {6} Q3: {7} ";

    public BoxAndWhiskerXYToolTipGenerator() {
        super(DEFAULT_TOOL_TIP_FORMAT, NumberFormat.getInstance(), NumberFormat.getInstance());
    }

    public BoxAndWhiskerXYToolTipGenerator(String toolTipFormat, DateFormat dateFormat, NumberFormat numberFormat) {
        super(toolTipFormat, dateFormat, numberFormat);
    }

    protected Object[] createItemArray(XYDataset dataset, int series, int item) {
        Object[] result2 = new Object[8];
        result2[0] = dataset.getSeriesKey(series).toString();
        Number x = dataset.getX(series, item);
        result2[1] = this.getXDateFormat() != null ? this.getXDateFormat().format(new Date(x.longValue())) : this.getXFormat().format(x);
        NumberFormat formatter = this.getYFormat();
        if (dataset instanceof BoxAndWhiskerXYDataset) {
            BoxAndWhiskerXYDataset d = (BoxAndWhiskerXYDataset)dataset;
            result2[2] = formatter.format(d.getMeanValue(series, item));
            result2[3] = formatter.format(d.getMedianValue(series, item));
            result2[4] = formatter.format(d.getMinRegularValue(series, item));
            result2[5] = formatter.format(d.getMaxRegularValue(series, item));
            result2[6] = formatter.format(d.getQ1Value(series, item));
            result2[7] = formatter.format(d.getQ3Value(series, item));
        }
        return result2;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BoxAndWhiskerXYToolTipGenerator)) {
            return false;
        }
        return super.equals(obj);
    }
}

