/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import org.jfree.data.DefaultKeyedValues;
import org.jfree.data.KeyedValues;
import org.jfree.data.Values2D;

public abstract class DataUtilities {
    public static double calculateColumnTotal(Values2D data, int column) {
        double total = 0.0;
        int rowCount = data.getRowCount();
        for (int r = 0; r < rowCount; ++r) {
            Number n = data.getValue(r, column);
            if (n == null) continue;
            total += n.doubleValue();
        }
        return total;
    }

    public static double calculateRowTotal(Values2D data, int row) {
        double total = 0.0;
        int columnCount = data.getColumnCount();
        for (int c2 = 0; c2 < columnCount; ++c2) {
            Number n = data.getValue(row, c2);
            if (n == null) continue;
            total += n.doubleValue();
        }
        return total;
    }

    public static Number[] createNumberArray(double[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Null 'data' argument.");
        }
        Number[] result2 = new Number[data.length];
        for (int i = 0; i < data.length; ++i) {
            result2[i] = new Double(data[i]);
        }
        return result2;
    }

    public static Number[][] createNumberArray2D(double[][] data) {
        if (data == null) {
            throw new IllegalArgumentException("Null 'data' argument.");
        }
        int l1 = data.length;
        Number[][] result2 = new Number[l1][];
        for (int i = 0; i < l1; ++i) {
            result2[i] = DataUtilities.createNumberArray(data[i]);
        }
        return result2;
    }

    public static KeyedValues getCumulativePercentages(KeyedValues data) {
        if (data == null) {
            throw new IllegalArgumentException("Null 'data' argument.");
        }
        DefaultKeyedValues result2 = new DefaultKeyedValues();
        double total = 0.0;
        for (int i = 0; i < data.getItemCount(); ++i) {
            Number v = data.getValue(i);
            if (v == null) continue;
            total += v.doubleValue();
        }
        double runningTotal = 0.0;
        for (int i = 0; i < data.getItemCount(); ++i) {
            Number v = data.getValue(i);
            if (v != null) {
                runningTotal += v.doubleValue();
            }
            result2.addValue(data.getKey(i), new Double(runningTotal / total));
        }
        return result2;
    }
}

