/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public class KeyToGroupMap
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -2228169345475318082L;
    private Comparable defaultGroup;
    private List groups;
    private Map keyToGroupMap;

    public KeyToGroupMap() {
        this((Comparable)((Object)"Default Group"));
    }

    public KeyToGroupMap(Comparable defaultGroup) {
        if (defaultGroup == null) {
            throw new IllegalArgumentException("Null 'defaultGroup' argument.");
        }
        this.defaultGroup = defaultGroup;
        this.groups = new ArrayList();
        this.keyToGroupMap = new HashMap();
    }

    public int getGroupCount() {
        return this.groups.size() + 1;
    }

    public List getGroups() {
        ArrayList<Comparable> result2 = new ArrayList<Comparable>();
        result2.add(this.defaultGroup);
        Iterator iterator = this.groups.iterator();
        while (iterator.hasNext()) {
            Comparable group = (Comparable)iterator.next();
            if (result2.contains(group)) continue;
            result2.add(group);
        }
        return result2;
    }

    public int getGroupIndex(Comparable group) {
        int result2 = this.groups.indexOf(group);
        if (result2 < 0) {
            if (this.defaultGroup.equals(group)) {
                result2 = 0;
            }
        } else {
            ++result2;
        }
        return result2;
    }

    public Comparable getGroup(Comparable key) {
        if (key == null) {
            throw new IllegalArgumentException("Null 'key' argument.");
        }
        Comparable result2 = this.defaultGroup;
        Comparable group = (Comparable)this.keyToGroupMap.get(key);
        if (group != null) {
            result2 = group;
        }
        return result2;
    }

    public void mapKeyToGroup(Comparable key, Comparable group) {
        int count;
        if (key == null) {
            throw new IllegalArgumentException("Null 'key' argument.");
        }
        Comparable currentGroup = this.getGroup(key);
        if (!currentGroup.equals(this.defaultGroup) && !currentGroup.equals(group) && (count = this.getKeyCount(currentGroup)) == 1) {
            this.groups.remove(currentGroup);
        }
        if (group == null) {
            this.keyToGroupMap.remove(key);
        } else {
            if (!this.groups.contains(group) && !this.defaultGroup.equals(group)) {
                this.groups.add(group);
            }
            this.keyToGroupMap.put(key, group);
        }
    }

    public int getKeyCount(Comparable group) {
        if (group == null) {
            throw new IllegalArgumentException("Null 'group' argument.");
        }
        int result2 = 0;
        Iterator iterator = this.keyToGroupMap.values().iterator();
        while (iterator.hasNext()) {
            Comparable g = (Comparable)iterator.next();
            if (!group.equals(g)) continue;
            ++result2;
        }
        return result2;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof KeyToGroupMap)) {
            return false;
        }
        KeyToGroupMap that = (KeyToGroupMap)obj;
        if (!ObjectUtilities.equal(this.defaultGroup, that.defaultGroup)) {
            return false;
        }
        return ((Object)this.keyToGroupMap).equals(that.keyToGroupMap);
    }

    public Object clone() throws CloneNotSupportedException {
        KeyToGroupMap result2 = (KeyToGroupMap)super.clone();
        result2.defaultGroup = (Comparable)KeyToGroupMap.clone(this.defaultGroup);
        result2.groups = (List)KeyToGroupMap.clone(this.groups);
        result2.keyToGroupMap = (Map)KeyToGroupMap.clone(this.keyToGroupMap);
        return result2;
    }

    private static Object clone(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> c2 = object.getClass();
        Object result2 = null;
        try {
            Method m = c2.getMethod("clone", null);
            if (Modifier.isPublic(m.getModifiers())) {
                try {
                    result2 = m.invoke(object, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (NoSuchMethodException e) {
            result2 = object;
        }
        return result2;
    }

    private static Collection clone(Collection list) throws CloneNotSupportedException {
        List result2 = null;
        if (list != null) {
            try {
                List clone = (List)list.getClass().newInstance();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    clone.add(KeyToGroupMap.clone(iterator.next()));
                }
                result2 = clone;
            }
            catch (Exception e) {
                throw new CloneNotSupportedException("Exception.");
            }
        }
        return result2;
    }
}

