/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.category;

import java.util.List;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.AbstractDataset;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.general.PieDataset;
import org.jfree.util.TableOrder;

public class CategoryToPieDataset
extends AbstractDataset
implements PieDataset,
DatasetChangeListener {
    private CategoryDataset source;
    private TableOrder extract;
    private int index;

    public CategoryToPieDataset(CategoryDataset source, TableOrder extract, int index) {
        if (extract == null) {
            throw new IllegalArgumentException("Null 'extract' argument.");
        }
        this.source = source;
        this.source.addChangeListener(this);
        this.extract = extract;
        this.index = index;
    }

    public int getItemCount() {
        int result2 = 0;
        if (this.source != null) {
            if (this.extract == TableOrder.BY_ROW) {
                result2 = this.source.getColumnCount();
            } else if (this.extract == TableOrder.BY_COLUMN) {
                result2 = this.source.getRowCount();
            }
        }
        return result2;
    }

    public Number getValue(int item) {
        Number result2 = null;
        if (this.source != null) {
            if (this.extract == TableOrder.BY_ROW) {
                result2 = this.source.getValue(this.index, item);
            } else if (this.extract == TableOrder.BY_COLUMN) {
                result2 = this.source.getValue(item, this.index);
            }
        }
        return result2;
    }

    public Comparable getKey(int index) {
        Comparable result2 = null;
        if (this.extract == TableOrder.BY_ROW) {
            result2 = this.source.getColumnKey(index);
        } else if (this.extract == TableOrder.BY_COLUMN) {
            result2 = this.source.getRowKey(index);
        }
        return result2;
    }

    public int getIndex(Comparable key) {
        int result2 = -1;
        if (this.extract == TableOrder.BY_ROW) {
            result2 = this.source.getColumnIndex(key);
        } else if (this.extract == TableOrder.BY_COLUMN) {
            result2 = this.source.getRowIndex(key);
        }
        return result2;
    }

    public List getKeys() {
        List result2 = null;
        if (this.extract == TableOrder.BY_ROW) {
            result2 = this.source.getColumnKeys();
        } else if (this.extract == TableOrder.BY_COLUMN) {
            result2 = this.source.getRowKeys();
        }
        return result2;
    }

    public Number getValue(Comparable key) {
        Number result2 = null;
        int keyIndex = this.getIndex(key);
        if (this.extract == TableOrder.BY_ROW) {
            result2 = this.source.getValue(this.index, keyIndex);
        } else if (this.extract == TableOrder.BY_COLUMN) {
            result2 = this.source.getValue(keyIndex, this.index);
        }
        return result2;
    }

    public void datasetChanged(DatasetChangeEvent event) {
        this.fireDatasetChanged();
    }
}

