/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.general;

import org.jfree.data.general.CombinationDataset;
import org.jfree.data.general.SeriesDataset;
import org.jfree.data.xy.AbstractIntervalXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.OHLCDataset;
import org.jfree.data.xy.SignalsDataset;
import org.jfree.data.xy.XYDataset;

public class SubSeriesDataset
extends AbstractIntervalXYDataset
implements OHLCDataset,
SignalsDataset,
IntervalXYDataset,
CombinationDataset {
    private SeriesDataset parent = null;
    private int[] map;

    public SubSeriesDataset(SeriesDataset parent, int[] map) {
        this.parent = parent;
        this.map = map;
    }

    public SubSeriesDataset(SeriesDataset parent, int series) {
        this(parent, new int[]{series});
    }

    public Number getHigh(int series, int item) {
        return ((OHLCDataset)this.parent).getHigh(this.map[series], item);
    }

    public double getHighValue(int series, int item) {
        double result2 = Double.NaN;
        Number high = this.getHigh(series, item);
        if (high != null) {
            result2 = high.doubleValue();
        }
        return result2;
    }

    public Number getLow(int series, int item) {
        return ((OHLCDataset)this.parent).getLow(this.map[series], item);
    }

    public double getLowValue(int series, int item) {
        double result2 = Double.NaN;
        Number low = this.getLow(series, item);
        if (low != null) {
            result2 = low.doubleValue();
        }
        return result2;
    }

    public Number getOpen(int series, int item) {
        return ((OHLCDataset)this.parent).getOpen(this.map[series], item);
    }

    public double getOpenValue(int series, int item) {
        double result2 = Double.NaN;
        Number open = this.getOpen(series, item);
        if (open != null) {
            result2 = open.doubleValue();
        }
        return result2;
    }

    public Number getClose(int series, int item) {
        return ((OHLCDataset)this.parent).getClose(this.map[series], item);
    }

    public double getCloseValue(int series, int item) {
        double result2 = Double.NaN;
        Number close = this.getClose(series, item);
        if (close != null) {
            result2 = close.doubleValue();
        }
        return result2;
    }

    public Number getVolume(int series, int item) {
        return ((OHLCDataset)this.parent).getVolume(this.map[series], item);
    }

    public double getVolumeValue(int series, int item) {
        double result2 = Double.NaN;
        Number volume = this.getVolume(series, item);
        if (volume != null) {
            result2 = volume.doubleValue();
        }
        return result2;
    }

    public Number getX(int series, int item) {
        return ((XYDataset)this.parent).getX(this.map[series], item);
    }

    public Number getY(int series, int item) {
        return ((XYDataset)this.parent).getY(this.map[series], item);
    }

    public int getItemCount(int series) {
        return ((XYDataset)this.parent).getItemCount(this.map[series]);
    }

    public int getSeriesCount() {
        return this.map.length;
    }

    public Comparable getSeriesKey(int series) {
        return this.parent.getSeriesKey(this.map[series]);
    }

    public Number getStartX(int series, int item) {
        if (this.parent instanceof IntervalXYDataset) {
            return ((IntervalXYDataset)this.parent).getStartX(this.map[series], item);
        }
        return this.getX(series, item);
    }

    public Number getEndX(int series, int item) {
        if (this.parent instanceof IntervalXYDataset) {
            return ((IntervalXYDataset)this.parent).getEndX(this.map[series], item);
        }
        return this.getX(series, item);
    }

    public Number getStartY(int series, int item) {
        if (this.parent instanceof IntervalXYDataset) {
            return ((IntervalXYDataset)this.parent).getStartY(this.map[series], item);
        }
        return this.getY(series, item);
    }

    public Number getEndY(int series, int item) {
        if (this.parent instanceof IntervalXYDataset) {
            return ((IntervalXYDataset)this.parent).getEndY(this.map[series], item);
        }
        return this.getY(series, item);
    }

    public int getType(int series, int item) {
        if (this.parent instanceof SignalsDataset) {
            return ((SignalsDataset)this.parent).getType(this.map[series], item);
        }
        return this.getY(series, item).intValue();
    }

    public double getLevel(int series, int item) {
        if (this.parent instanceof SignalsDataset) {
            return ((SignalsDataset)this.parent).getLevel(this.map[series], item);
        }
        return this.getYValue(series, item);
    }

    public SeriesDataset getParent() {
        return this.parent;
    }

    public int[] getMap() {
        return (int[])this.map.clone();
    }
}

