/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jfree.data.Range;
import org.jfree.data.RangeInfo;
import org.jfree.data.statistics.BoxAndWhiskerItem;
import org.jfree.data.statistics.BoxAndWhiskerXYDataset;
import org.jfree.data.xy.AbstractXYDataset;

public class DefaultBoxAndWhiskerXYDataset
extends AbstractXYDataset
implements BoxAndWhiskerXYDataset,
RangeInfo {
    private Comparable seriesKey;
    private List dates;
    private List items;
    private Number minimumRangeValue;
    private Number maximumRangeValue;
    private Range rangeBounds;
    private double outlierCoefficient = 1.5;
    private double faroutCoefficient = 2.0;

    public DefaultBoxAndWhiskerXYDataset(Comparable seriesKey) {
        this.seriesKey = seriesKey;
        this.dates = new ArrayList();
        this.items = new ArrayList();
        this.minimumRangeValue = null;
        this.maximumRangeValue = null;
        this.rangeBounds = null;
    }

    public void add(Date date, BoxAndWhiskerItem item) {
        this.dates.add(date);
        this.items.add(item);
        if (this.minimumRangeValue == null) {
            this.minimumRangeValue = item.getMinRegularValue();
        } else if (item.getMinRegularValue().doubleValue() < this.minimumRangeValue.doubleValue()) {
            this.minimumRangeValue = item.getMinRegularValue();
        }
        if (this.maximumRangeValue == null) {
            this.maximumRangeValue = item.getMaxRegularValue();
        } else if (item.getMaxRegularValue().doubleValue() > this.maximumRangeValue.doubleValue()) {
            this.maximumRangeValue = item.getMaxRegularValue();
        }
        this.rangeBounds = new Range(this.minimumRangeValue.doubleValue(), this.maximumRangeValue.doubleValue());
    }

    public Comparable getSeriesKey(int i) {
        return this.seriesKey;
    }

    public BoxAndWhiskerItem getItem(int series, int item) {
        return (BoxAndWhiskerItem)this.items.get(item);
    }

    public Number getX(int series, int item) {
        return new Long(((Date)this.dates.get(item)).getTime());
    }

    public Date getXDate(int series, int item) {
        return (Date)this.dates.get(item);
    }

    public Number getY(int series, int item) {
        return new Double(this.getMeanValue(series, item).doubleValue());
    }

    public Number getMeanValue(int series, int item) {
        Number result2 = null;
        BoxAndWhiskerItem stats = (BoxAndWhiskerItem)this.items.get(item);
        if (stats != null) {
            result2 = stats.getMean();
        }
        return result2;
    }

    public Number getMedianValue(int series, int item) {
        Number result2 = null;
        BoxAndWhiskerItem stats = (BoxAndWhiskerItem)this.items.get(item);
        if (stats != null) {
            result2 = stats.getMedian();
        }
        return result2;
    }

    public Number getQ1Value(int series, int item) {
        Number result2 = null;
        BoxAndWhiskerItem stats = (BoxAndWhiskerItem)this.items.get(item);
        if (stats != null) {
            result2 = stats.getQ1();
        }
        return result2;
    }

    public Number getQ3Value(int series, int item) {
        Number result2 = null;
        BoxAndWhiskerItem stats = (BoxAndWhiskerItem)this.items.get(item);
        if (stats != null) {
            result2 = stats.getQ3();
        }
        return result2;
    }

    public Number getMinRegularValue(int series, int item) {
        Number result2 = null;
        BoxAndWhiskerItem stats = (BoxAndWhiskerItem)this.items.get(item);
        if (stats != null) {
            result2 = stats.getMinRegularValue();
        }
        return result2;
    }

    public Number getMaxRegularValue(int series, int item) {
        Number result2 = null;
        BoxAndWhiskerItem stats = (BoxAndWhiskerItem)this.items.get(item);
        if (stats != null) {
            result2 = stats.getMaxRegularValue();
        }
        return result2;
    }

    public Number getMinOutlier(int series, int item) {
        Number result2 = null;
        BoxAndWhiskerItem stats = (BoxAndWhiskerItem)this.items.get(item);
        if (stats != null) {
            result2 = stats.getMinOutlier();
        }
        return result2;
    }

    public Number getMaxOutlier(int series, int item) {
        Number result2 = null;
        BoxAndWhiskerItem stats = (BoxAndWhiskerItem)this.items.get(item);
        if (stats != null) {
            result2 = stats.getMaxOutlier();
        }
        return result2;
    }

    public List getOutliers(int series, int item) {
        List result2 = null;
        BoxAndWhiskerItem stats = (BoxAndWhiskerItem)this.items.get(item);
        if (stats != null) {
            result2 = stats.getOutliers();
        }
        return result2;
    }

    public double getOutlierCoefficient() {
        return this.outlierCoefficient;
    }

    public double getFaroutCoefficient() {
        return this.faroutCoefficient;
    }

    public int getSeriesCount() {
        return 1;
    }

    public int getItemCount(int series) {
        return this.dates.size();
    }

    public void setOutlierCoefficient(double outlierCoefficient) {
        this.outlierCoefficient = outlierCoefficient;
    }

    public void setFaroutCoefficient(double faroutCoefficient) {
        if (!(faroutCoefficient > this.getOutlierCoefficient())) {
            throw new IllegalArgumentException("Farout value must be greater than the outlier value, which is currently set at: (" + this.getOutlierCoefficient() + ")");
        }
        this.faroutCoefficient = faroutCoefficient;
    }

    public double getRangeLowerBound(boolean includeInterval) {
        double result2 = Double.NaN;
        if (this.minimumRangeValue != null) {
            result2 = this.minimumRangeValue.doubleValue();
        }
        return result2;
    }

    public double getRangeUpperBound(boolean includeInterval) {
        double result2 = Double.NaN;
        if (this.maximumRangeValue != null) {
            result2 = this.maximumRangeValue.doubleValue();
        }
        return result2;
    }

    public Range getRangeBounds(boolean includeInterval) {
        return this.rangeBounds;
    }
}

