/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimePeriodFormatException;
import org.jfree.data.time.Year;

public class Week
extends RegularTimePeriod
implements Serializable {
    private static final long serialVersionUID = 1856387786939865061L;
    public static final int FIRST_WEEK_IN_YEAR = 1;
    public static final int LAST_WEEK_IN_YEAR = 53;
    private Year year;
    private int week;

    public Week() {
        this(new Date());
    }

    public Week(int week, int year) {
        this(week, new Year(year));
    }

    public Week(int week, Year year) {
        if (week < 1 && week > 53) {
            throw new IllegalArgumentException("The 'week' argument must be in the range 1 - 53.");
        }
        this.week = week;
        this.year = year;
    }

    public Week(Date time) {
        this(time, RegularTimePeriod.DEFAULT_TIME_ZONE);
    }

    public Week(Date time, TimeZone zone) {
        if (time == null) {
            throw new IllegalArgumentException("Null 'time' argument.");
        }
        if (zone == null) {
            throw new IllegalArgumentException("Null 'zone' argument.");
        }
        Calendar calendar = Calendar.getInstance(zone);
        calendar.setTime(time);
        int tempWeek = calendar.get(3);
        if (tempWeek == 1 && calendar.get(2) == 11) {
            this.week = 1;
            this.year = new Year(calendar.get(1) + 1);
        } else {
            this.week = Math.min(tempWeek, 53);
            this.year = new Year(calendar.get(1));
        }
    }

    public Year getYear() {
        return this.year;
    }

    public int getYearValue() {
        return this.year.getYear();
    }

    public int getWeek() {
        return this.week;
    }

    public RegularTimePeriod previous() {
        Week result2;
        if (this.week != 1) {
            result2 = new Week(this.week - 1, this.year);
        } else {
            Year prevYear = (Year)this.year.previous();
            if (prevYear != null) {
                int yy = prevYear.getYear();
                Calendar prevYearCalendar = Calendar.getInstance();
                prevYearCalendar.set(yy, 11, 31);
                result2 = new Week(prevYearCalendar.getActualMaximum(3), prevYear);
            } else {
                result2 = null;
            }
        }
        return result2;
    }

    public RegularTimePeriod next() {
        Week result2;
        if (this.week < 52) {
            result2 = new Week(this.week + 1, this.year);
        } else {
            Year nextYear;
            Calendar calendar = Calendar.getInstance();
            calendar.set(this.year.getYear(), 11, 31);
            int actualMaxWeek = calendar.getActualMaximum(3);
            result2 = this.week != actualMaxWeek ? new Week(this.week + 1, this.year) : ((nextYear = (Year)this.year.next()) != null ? new Week(1, nextYear) : null);
        }
        return result2;
    }

    public long getSerialIndex() {
        return (long)this.year.getYear() * 53L + (long)this.week;
    }

    public long getFirstMillisecond(Calendar calendar) {
        Calendar c2 = (Calendar)calendar.clone();
        c2.clear();
        c2.set(1, this.year.getYear());
        c2.set(3, this.week);
        c2.set(7, c2.getFirstDayOfWeek());
        c2.set(10, 0);
        c2.set(12, 0);
        c2.set(13, 0);
        c2.set(14, 0);
        return c2.getTime().getTime();
    }

    public long getLastMillisecond(Calendar calendar) {
        RegularTimePeriod next = this.next();
        return next.getFirstMillisecond(calendar) - 1L;
    }

    public String toString() {
        return "Week " + this.week + ", " + this.year;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Week)) {
            return false;
        }
        Week that = (Week)obj;
        if (this.week != that.week) {
            return false;
        }
        return this.year.equals(that.year);
    }

    public int hashCode() {
        int result2 = 17;
        result2 = 37 * result2 + this.week;
        result2 = 37 * result2 + this.year.hashCode();
        return result2;
    }

    public int compareTo(Object o1) {
        int result2;
        if (o1 instanceof Week) {
            Week w = (Week)o1;
            result2 = this.year.getYear() - w.getYear().getYear();
            if (result2 == 0) {
                result2 = this.week - w.getWeek();
            }
        } else {
            result2 = o1 instanceof RegularTimePeriod ? 0 : 1;
        }
        return result2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Week parseWeek(String s) {
        Week result2 = null;
        if (s == null) return result2;
        int i = Week.findSeparator(s = s.trim());
        if (i == -1) throw new TimePeriodFormatException("Could not find separator.");
        String s1 = s.substring(0, i).trim();
        String s2 = s.substring(i + 1, s.length()).trim();
        Year y = Week.evaluateAsYear(s1);
        if (y != null) {
            int w = Week.stringToWeek(s2);
            if (w != -1) return new Week(w, y);
            throw new TimePeriodFormatException("Can't evaluate the week.");
        }
        y = Week.evaluateAsYear(s2);
        if (y == null) throw new TimePeriodFormatException("Can't evaluate the year.");
        int w = Week.stringToWeek(s1);
        if (w != -1) return new Week(w, y);
        throw new TimePeriodFormatException("Can't evaluate the week.");
    }

    private static int findSeparator(String s) {
        int result2 = s.indexOf(45);
        if (result2 == -1) {
            result2 = s.indexOf(44);
        }
        if (result2 == -1) {
            result2 = s.indexOf(32);
        }
        if (result2 == -1) {
            result2 = s.indexOf(46);
        }
        return result2;
    }

    private static Year evaluateAsYear(String s) {
        Year result2 = null;
        try {
            result2 = Year.parseYear(s);
        }
        catch (TimePeriodFormatException timePeriodFormatException) {
            // empty catch block
        }
        return result2;
    }

    private static int stringToWeek(String s) {
        int result2 = -1;
        s = s.replace('W', ' ');
        s = s.trim();
        try {
            result2 = Integer.parseInt(s);
            if (result2 < 1 || result2 > 53) {
                result2 = -1;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result2;
    }
}

