/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy;

import java.io.Serializable;
import org.jfree.data.DomainInfo;
import org.jfree.data.Range;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.xy.XYDataset;
import org.jfree.util.PublicCloneable;

public class IntervalXYDelegate
implements DomainInfo,
Serializable,
Cloneable,
PublicCloneable {
    private static final long serialVersionUID = -685166711639592857L;
    private XYDataset dataset;
    private boolean autoWidth;
    private double intervalPositionFactor;
    private double intervalWidth;
    private double autoIntervalWidth;
    private double lowerBound;
    private double upperBound;

    public IntervalXYDelegate(XYDataset dataset) {
        this(dataset, true);
    }

    public IntervalXYDelegate(XYDataset dataset, boolean autoWidth) {
        this.autoWidth = autoWidth;
        this.dataset = dataset;
        this.intervalPositionFactor = 0.5;
        this.autoWidth = autoWidth;
        this.autoIntervalWidth = Double.POSITIVE_INFINITY;
        this.intervalWidth = 1.0;
    }

    public boolean isAutoWidth() {
        return this.autoWidth;
    }

    public void setAutoWidth(boolean b2) {
        this.autoWidth = b2;
    }

    public double getIntervalPositionFactor() {
        return this.intervalPositionFactor;
    }

    public void setIntervalPositionFactor(double d) {
        if (d < 0.0 || 1.0 < d) {
            throw new IllegalArgumentException("Argument 'd' outside valid range.");
        }
        this.intervalPositionFactor = d;
    }

    public void setIntervalWidth(double w) {
        if (w < 0.0) {
            throw new IllegalArgumentException("Negative 'w' argument.");
        }
        this.intervalWidth = w;
    }

    public double getIntervalWidth() {
        if (this.isAutoWidth() && !Double.isInfinite(this.autoIntervalWidth)) {
            return this.autoIntervalWidth;
        }
        return this.intervalWidth;
    }

    public Number getStartX(int series, int item) {
        Double startX = null;
        Number x = this.dataset.getX(series, item);
        if (x != null) {
            startX = new Double(x.doubleValue() - this.getIntervalPositionFactor() * this.getIntervalWidth());
        }
        return startX;
    }

    public Number getEndX(int series, int item) {
        Double endX = null;
        Number x = this.dataset.getX(series, item);
        if (x != null) {
            endX = new Double(x.doubleValue() + (1.0 - this.getIntervalPositionFactor()) * this.getIntervalWidth());
        }
        return endX;
    }

    public double getDomainLowerBound(boolean includeInterval) {
        double result2 = Double.NaN;
        Range r = this.getDomainBounds(includeInterval);
        if (r != null) {
            result2 = r.getLowerBound();
        }
        return result2;
    }

    public double getDomainUpperBound(boolean includeInterval) {
        double result2 = Double.NaN;
        Range r = this.getDomainBounds(includeInterval);
        if (r != null) {
            result2 = r.getUpperBound();
        }
        return result2;
    }

    public Range getDomainBounds(boolean includeInterval) {
        Range range = DatasetUtilities.iterateDomainBounds(this.dataset, includeInterval);
        if (this.dataset.getSeriesCount() == 1 && this.dataset.getItemCount(0) == 1) {
            range = new Range(range.getLowerBound() - this.getIntervalWidth(), range.getUpperBound() + this.getIntervalWidth());
        }
        return range;
    }

    public void itemAdded(int series, int item) {
        double after;
        double before;
        double delta;
        double x = this.dataset.getXValue(series, item);
        if (item > 0 && (delta = x - (before = this.dataset.getXValue(series, item - 1))) < this.autoIntervalWidth) {
            this.autoIntervalWidth = delta;
            this.lowerBound = before;
            this.upperBound = x;
        }
        if (item + 1 < this.dataset.getItemCount(series) && (delta = (after = this.dataset.getXValue(series, item + 1)) - x) < this.autoIntervalWidth) {
            this.autoIntervalWidth = delta;
            this.lowerBound = x;
            this.upperBound = after;
        }
    }

    public void itemRemoved(double x) {
        if (x == this.lowerBound || x == this.upperBound) {
            this.recalculateIntervalWidth();
        }
    }

    private void recalculateIntervalWidth() {
        this.autoIntervalWidth = Double.POSITIVE_INFINITY;
        int seriesCount = this.dataset.getSeriesCount();
        for (int series = 0; series < seriesCount; ++series) {
            this.calculateSeries(series);
        }
    }

    private void calculateSeries(int series) {
        int totalCount = this.dataset.getItemCount(series);
        int itemCount = totalCount;
        for (int item = 1; item < itemCount; ++item) {
            double lower = this.dataset.getXValue(series, item - 1);
            double upper = this.dataset.getXValue(series, item);
            double delta = upper - lower;
            if (!(delta < this.autoIntervalWidth)) continue;
            this.autoIntervalWidth = delta;
            this.lowerBound = lower;
            this.upperBound = upper;
        }
    }

    public void seriesAdded(int series) {
        this.calculateSeries(series);
    }

    public void seriesRemoved() {
        this.recalculateIntervalWidth();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IntervalXYDelegate)) {
            return false;
        }
        IntervalXYDelegate that = (IntervalXYDelegate)obj;
        if (this.autoWidth != that.autoWidth) {
            return false;
        }
        if (this.intervalPositionFactor != that.intervalPositionFactor) {
            return false;
        }
        return this.intervalWidth == that.intervalWidth;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

