/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.date;

import org.jfree.date.AnnualDateRule;
import org.jfree.date.SerialDate;

public class DayOfWeekInMonthRule
extends AnnualDateRule {
    private int count;
    private int dayOfWeek;
    private int month;

    public DayOfWeekInMonthRule() {
        this(1, 2, 1);
    }

    public DayOfWeekInMonthRule(int count, int dayOfWeek, int month) {
        this.count = count;
        this.dayOfWeek = dayOfWeek;
        this.month = month;
    }

    public int getCount() {
        return this.count;
    }

    public SerialDate getDate(int year) {
        SerialDate result2;
        if (this.count != 0) {
            result2 = SerialDate.createInstance(1, this.month, year);
            while (result2.getDayOfWeek() != this.dayOfWeek) {
                result2 = SerialDate.addDays(1, result2);
            }
            result2 = SerialDate.addDays(7 * (this.count - 1), result2);
        } else {
            result2 = SerialDate.createInstance(1, this.month, year);
            result2 = result2.getEndOfCurrentMonth(result2);
            while (result2.getDayOfWeek() != this.dayOfWeek) {
                result2 = SerialDate.addDays(-1, result2);
            }
        }
        return result2;
    }

    public int getDayOfWeek() {
        return this.dayOfWeek;
    }

    public int getMonth() {
        return this.month;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setDayOfWeek(int dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
    }

    public void setMonth(int month) {
        this.month = month;
    }
}

