/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui;

import java.io.File;
import java.io.FilenameFilter;
import javax.swing.filechooser.FileFilter;

public class FilesystemFilter
extends FileFilter
implements FilenameFilter {
    private String[] fileext;
    private String descr;
    private boolean accDirs;

    public FilesystemFilter(String fileext, String descr) {
        this(fileext, descr, true);
    }

    public FilesystemFilter(String fileext, String descr, boolean accDirs) {
        this(new String[]{fileext}, descr, accDirs);
    }

    public FilesystemFilter(String[] fileext, String descr, boolean accDirs) {
        this.fileext = (String[])fileext.clone();
        this.descr = descr;
        this.accDirs = accDirs;
    }

    public boolean accept(File dir) {
        if (dir.isDirectory() && this.acceptsDirectories()) {
            return true;
        }
        int i = 0;
        while (i < this.fileext.length) {
            if (dir.getName().endsWith(this.fileext[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean accept(File dir, String name) {
        File f = new File(dir, name);
        if (f.isDirectory() && this.acceptsDirectories()) {
            return true;
        }
        int i = 0;
        while (i < this.fileext.length) {
            if (name.endsWith(this.fileext[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void acceptDirectories(boolean b2) {
        this.accDirs = b2;
    }

    public boolean acceptsDirectories() {
        return this.accDirs;
    }

    public String getDescription() {
        return this.descr;
    }
}

