/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui;

import java.awt.geom.Dimension2D;
import java.io.Serializable;

public class FloatDimension
extends Dimension2D
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 5367882923248086744L;
    private float width;
    private float height;

    public FloatDimension() {
        this.width = 0.0f;
        this.height = 0.0f;
    }

    public FloatDimension(float width, float height) {
        this.width = width;
        this.height = height;
    }

    public FloatDimension(FloatDimension fd) {
        this.width = fd.width;
        this.height = fd.height;
    }

    public Object clone() {
        return super.clone();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FloatDimension)) {
            return false;
        }
        FloatDimension floatDimension = (FloatDimension)o;
        if (this.height != floatDimension.height) {
            return false;
        }
        return this.width == floatDimension.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getWidth() {
        return this.width;
    }

    public int hashCode() {
        int result2 = Float.floatToIntBits(this.width);
        result2 = 29 * result2 + Float.floatToIntBits(this.height);
        return result2;
    }

    public void setHeight(double height) {
        this.height = (float)height;
    }

    public void setSize(double width, double height) {
        this.setHeight((float)height);
        this.setWidth((float)width);
    }

    public void setWidth(double width) {
        this.width = (float)width;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + ":={width=" + this.getWidth() + ", height=" + this.getHeight() + "}";
    }
}

