/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui;

import java.awt.geom.Rectangle2D;
import java.io.ObjectStreamException;
import java.io.Serializable;

public final class RectangleEdge
implements Serializable {
    private static final long serialVersionUID = -7400988293691093548L;
    public static final RectangleEdge TOP = new RectangleEdge("RectangleEdge.TOP");
    public static final RectangleEdge BOTTOM = new RectangleEdge("RectangleEdge.BOTTOM");
    public static final RectangleEdge LEFT = new RectangleEdge("RectangleEdge.LEFT");
    public static final RectangleEdge RIGHT = new RectangleEdge("RectangleEdge.RIGHT");
    private String name;

    private RectangleEdge(String name) {
        this.name = name;
    }

    public static double coordinate(Rectangle2D rectangle, RectangleEdge edge) {
        double result2 = 0.0;
        if (edge == TOP) {
            result2 = rectangle.getMinY();
        } else if (edge == BOTTOM) {
            result2 = rectangle.getMaxY();
        } else if (edge == LEFT) {
            result2 = rectangle.getMinX();
        } else if (edge == RIGHT) {
            result2 = rectangle.getMaxX();
        }
        return result2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RectangleEdge)) {
            return false;
        }
        RectangleEdge order = (RectangleEdge)o;
        return this.name.equals(order.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static boolean isLeftOrRight(RectangleEdge edge) {
        return edge == LEFT || edge == RIGHT;
    }

    public static boolean isTopOrBottom(RectangleEdge edge) {
        return edge == TOP || edge == BOTTOM;
    }

    public static RectangleEdge opposite(RectangleEdge edge) {
        RectangleEdge result2 = null;
        if (edge == TOP) {
            result2 = BOTTOM;
        } else if (edge == BOTTOM) {
            result2 = TOP;
        } else if (edge == LEFT) {
            result2 = RIGHT;
        } else if (edge == RIGHT) {
            result2 = LEFT;
        }
        return result2;
    }

    private Object readResolve() throws ObjectStreamException {
        RectangleEdge result2 = null;
        if (this.equals(TOP)) {
            result2 = TOP;
        } else if (this.equals(BOTTOM)) {
            result2 = BOTTOM;
        } else if (this.equals(LEFT)) {
            result2 = LEFT;
        } else if (this.equals(RIGHT)) {
            result2 = RIGHT;
        }
        return result2;
    }

    public String toString() {
        return this.name;
    }
}

