/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui;

import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.ui.LengthAdjustmentType;
import org.jfree.util.UnitType;

public class RectangleInsets
implements Serializable {
    private static final long serialVersionUID = 1902273207559319996L;
    public static final RectangleInsets ZERO_INSETS = new RectangleInsets(UnitType.ABSOLUTE, 0.0, 0.0, 0.0, 0.0);
    private UnitType unitType;
    private double top;
    private double left;
    private double bottom;
    private double right;

    public RectangleInsets(double top, double left, double bottom, double right) {
        this(UnitType.ABSOLUTE, top, left, bottom, right);
    }

    public RectangleInsets(UnitType unitType, double top, double left, double bottom, double right) {
        if (unitType == null) {
            throw new IllegalArgumentException("Null 'unitType' argument.");
        }
        this.unitType = unitType;
        this.top = top;
        this.bottom = bottom;
        this.left = left;
        this.right = right;
    }

    public double calculateBottomInset(double height) {
        double result2 = this.bottom;
        if (this.unitType == UnitType.RELATIVE) {
            result2 = this.bottom * height;
        }
        return result2;
    }

    public double calculateBottomOutset(double height) {
        double result2 = this.bottom;
        if (this.unitType == UnitType.RELATIVE) {
            result2 = height / (1.0 - this.top - this.bottom) * this.bottom;
        }
        return result2;
    }

    public double calculateLeftInset(double width) {
        double result2 = this.left;
        if (this.unitType == UnitType.RELATIVE) {
            result2 = this.left * width;
        }
        return result2;
    }

    public double calculateLeftOutset(double width) {
        double result2 = this.left;
        if (this.unitType == UnitType.RELATIVE) {
            result2 = width / (1.0 - this.left - this.right) * this.left;
        }
        return result2;
    }

    public double calculateRightInset(double width) {
        double result2 = this.right;
        if (this.unitType == UnitType.RELATIVE) {
            result2 = this.right * width;
        }
        return result2;
    }

    public double calculateRightOutset(double width) {
        double result2 = this.right;
        if (this.unitType == UnitType.RELATIVE) {
            result2 = width / (1.0 - this.left - this.right) * this.right;
        }
        return result2;
    }

    public double calculateTopInset(double height) {
        double result2 = this.top;
        if (this.unitType == UnitType.RELATIVE) {
            result2 = this.top * height;
        }
        return result2;
    }

    public double calculateTopOutset(double height) {
        double result2 = this.top;
        if (this.unitType == UnitType.RELATIVE) {
            result2 = height / (1.0 - this.top - this.bottom) * this.top;
        }
        return result2;
    }

    public Rectangle2D createAdjustedRectangle(Rectangle2D base, LengthAdjustmentType horizontal, LengthAdjustmentType vertical) {
        double topMargin;
        if (base == null) {
            throw new IllegalArgumentException("Null 'base' argument.");
        }
        double x = base.getX();
        double y = base.getY();
        double w = base.getWidth();
        double h = base.getHeight();
        if (horizontal == LengthAdjustmentType.EXPAND) {
            double leftOutset = this.calculateLeftOutset(w);
            x -= leftOutset;
            w = w + leftOutset + this.calculateRightOutset(w);
        } else if (horizontal == LengthAdjustmentType.CONTRACT) {
            double leftMargin = this.calculateLeftInset(w);
            x += leftMargin;
            w = w - leftMargin - this.calculateRightInset(w);
        }
        if (vertical == LengthAdjustmentType.EXPAND) {
            topMargin = this.calculateTopOutset(h);
            y -= topMargin;
            h = h + topMargin + this.calculateBottomOutset(h);
        } else if (vertical == LengthAdjustmentType.CONTRACT) {
            topMargin = this.calculateTopInset(h);
            y += topMargin;
            h = h - topMargin - this.calculateBottomInset(h);
        }
        return new Rectangle2D.Double(x, y, w, h);
    }

    public Rectangle2D createInsetRectangle(Rectangle2D base) {
        return this.createInsetRectangle(base, true, true);
    }

    public Rectangle2D createInsetRectangle(Rectangle2D base, boolean horizontal, boolean vertical) {
        if (base == null) {
            throw new IllegalArgumentException("Null 'base' argument.");
        }
        double topMargin = 0.0;
        double bottomMargin = 0.0;
        if (vertical) {
            topMargin = this.calculateTopInset(base.getHeight());
            bottomMargin = this.calculateBottomInset(base.getHeight());
        }
        double leftMargin = 0.0;
        double rightMargin = 0.0;
        if (horizontal) {
            leftMargin = this.calculateLeftInset(base.getWidth());
            rightMargin = this.calculateRightInset(base.getWidth());
        }
        return new Rectangle2D.Double(base.getX() + leftMargin, base.getY() + topMargin, base.getWidth() - leftMargin - rightMargin, base.getHeight() - topMargin - bottomMargin);
    }

    public Rectangle2D createOutsetRectangle(Rectangle2D base) {
        return this.createOutsetRectangle(base, true, true);
    }

    public Rectangle2D createOutsetRectangle(Rectangle2D base, boolean horizontal, boolean vertical) {
        if (base == null) {
            throw new IllegalArgumentException("Null 'base' argument.");
        }
        double topMargin = 0.0;
        double bottomMargin = 0.0;
        if (vertical) {
            topMargin = this.calculateTopOutset(base.getHeight());
            bottomMargin = this.calculateBottomOutset(base.getHeight());
        }
        double leftMargin = 0.0;
        double rightMargin = 0.0;
        if (horizontal) {
            leftMargin = this.calculateLeftOutset(base.getWidth());
            rightMargin = this.calculateRightOutset(base.getWidth());
        }
        return new Rectangle2D.Double(base.getX() - leftMargin, base.getY() - topMargin, base.getWidth() + leftMargin + rightMargin, base.getHeight() + topMargin + bottomMargin);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RectangleInsets)) {
            return false;
        }
        RectangleInsets that = (RectangleInsets)obj;
        if (that.unitType != this.unitType) {
            return false;
        }
        if (this.left != that.left) {
            return false;
        }
        if (this.right != that.right) {
            return false;
        }
        if (this.top != that.top) {
            return false;
        }
        return this.bottom == that.bottom;
    }

    public double extendHeight(double height) {
        return height + this.calculateTopOutset(height) + this.calculateBottomOutset(height);
    }

    public double extendWidth(double width) {
        return width + this.calculateLeftOutset(width) + this.calculateRightOutset(width);
    }

    public double getBottom() {
        return this.bottom;
    }

    public double getLeft() {
        return this.left;
    }

    public double getRight() {
        return this.right;
    }

    public double getTop() {
        return this.top;
    }

    public UnitType getUnitType() {
        return this.unitType;
    }

    public int hashCode() {
        int result2 = this.unitType != null ? this.unitType.hashCode() : 0;
        long temp = this.top != 0.0 ? Double.doubleToLongBits(this.top) : 0L;
        result2 = 29 * result2 + (int)(temp ^ temp >>> 32);
        temp = this.bottom != 0.0 ? Double.doubleToLongBits(this.bottom) : 0L;
        result2 = 29 * result2 + (int)(temp ^ temp >>> 32);
        temp = this.left != 0.0 ? Double.doubleToLongBits(this.left) : 0L;
        result2 = 29 * result2 + (int)(temp ^ temp >>> 32);
        temp = this.right != 0.0 ? Double.doubleToLongBits(this.right) : 0L;
        result2 = 29 * result2 + (int)(temp ^ temp >>> 32);
        return result2;
    }

    public void trim(Rectangle2D area) {
        double w = area.getWidth();
        double h = area.getHeight();
        double l = this.calculateLeftInset(w);
        double r = this.calculateRightInset(w);
        double t = this.calculateTopInset(h);
        double b2 = this.calculateBottomInset(h);
        area.setRect(area.getX() + l, area.getY() + t, w - l - r, h - t - b2);
    }

    public double trimHeight(double height) {
        return height - this.calculateTopInset(height) - this.calculateBottomInset(height);
    }

    public double trimWidth(double width) {
        return width - this.calculateLeftInset(width) - this.calculateRightInset(width);
    }
}

