/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui;

import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class Spacer
implements Serializable {
    private static final long serialVersionUID = 1464655984225158198L;
    public static final int RELATIVE = 0;
    public static final int ABSOLUTE = 1;
    public static final Spacer NO_SPACE = new Spacer(1, 0.0, 0.0, 0.0, 0.0);
    private int type;
    private double left;
    private double right;
    private double top;
    private double bottom;

    public Spacer(int type, double left, double top, double right, double bottom) {
        this.type = type;
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
    }

    public double calculateExtendedHeight(double height) {
        double result2 = height;
        if (this.type == 1) {
            result2 = result2 + this.top + this.bottom;
        } else if (this.type == 0) {
            result2 = result2 + this.top * height + this.bottom * height;
        }
        return result2;
    }

    public double calculateExtendedWidth(double width) {
        double result2 = width;
        if (this.type == 1) {
            result2 = result2 + this.left + this.right;
        } else if (this.type == 0) {
            result2 = result2 + this.left * width + this.right * width;
        }
        return result2;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Spacer)) {
            return false;
        }
        Spacer that = (Spacer)obj;
        if (this.type != that.type) {
            return false;
        }
        if (this.left != that.left) {
            return false;
        }
        if (this.right != that.right) {
            return false;
        }
        if (this.top != that.top) {
            return false;
        }
        return this.bottom == that.bottom;
    }

    public double getBottomSpace(double height) {
        double result2 = 0.0;
        if (this.type == 1) {
            result2 = this.bottom;
        } else if (this.type == 0) {
            result2 = this.bottom * height;
        }
        return result2;
    }

    public double getLeftSpace(double width) {
        double result2 = 0.0;
        if (this.type == 1) {
            result2 = this.left;
        } else if (this.type == 0) {
            result2 = this.left * width;
        }
        return result2;
    }

    public double getRightSpace(double width) {
        double result2 = 0.0;
        if (this.type == 1) {
            result2 = this.right;
        } else if (this.type == 0) {
            result2 = this.right * width;
        }
        return result2;
    }

    public double getTopSpace(double height) {
        double result2 = 0.0;
        if (this.type == 1) {
            result2 = this.top;
        } else if (this.type == 0) {
            result2 = this.top * height;
        }
        return result2;
    }

    public int hashCode() {
        int result2 = this.type;
        long temp = this.left != 0.0 ? Double.doubleToLongBits(this.left) : 0L;
        result2 = 29 * result2 + (int)(temp ^ temp >>> 32);
        temp = this.right != 0.0 ? Double.doubleToLongBits(this.right) : 0L;
        result2 = 29 * result2 + (int)(temp ^ temp >>> 32);
        temp = this.top != 0.0 ? Double.doubleToLongBits(this.top) : 0L;
        result2 = 29 * result2 + (int)(temp ^ temp >>> 32);
        temp = this.bottom != 0.0 ? Double.doubleToLongBits(this.bottom) : 0L;
        result2 = 29 * result2 + (int)(temp ^ temp >>> 32);
        return result2;
    }

    public void trim(Rectangle2D area) {
        if (area == null) {
            throw new IllegalArgumentException("Null 'area' argument.");
        }
        double x = area.getX();
        double y = area.getY();
        double h = area.getHeight();
        double w = area.getWidth();
        double l = this.getLeftSpace(w);
        double r = this.getRightSpace(w);
        double t = this.getTopSpace(h);
        double b2 = this.getBottomSpace(h);
        area.setRect(x + l, y + t, w - l - r, h - t - b2);
    }

    public double trimWidth(double w) {
        return w - this.getLeftSpace(w) - this.getRightSpace(w);
    }
}

