/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui.about;

import java.awt.Image;
import java.util.Iterator;
import java.util.List;
import org.jfree.base.BootableProjectInfo;
import org.jfree.base.Library;
import org.jfree.ui.about.Contributor;

public class ProjectInfo
extends BootableProjectInfo {
    private Image logo;
    private String licenceText;
    private List contributors;

    public ProjectInfo() {
    }

    public ProjectInfo(String name, String version, String info, Image logo, String copyright, String licenceName, String licenceText) {
        super(name, version, info, copyright, licenceName);
        this.logo = logo;
        this.licenceText = licenceText;
    }

    public List getContributors() {
        return this.contributors;
    }

    public String getLicenceText() {
        return this.licenceText;
    }

    public Image getLogo() {
        return this.logo;
    }

    public void setContributors(List contributors) {
        this.contributors = contributors;
    }

    public void setLicenceText(String licenceText) {
        this.licenceText = licenceText;
    }

    public void setLogo(Image logo) {
        this.logo = logo;
    }

    public String toString() {
        StringBuffer result2 = new StringBuffer();
        result2.append(this.getName());
        result2.append(" version ");
        result2.append(this.getVersion());
        result2.append(".\n");
        result2.append(this.getCopyright());
        result2.append(".\n");
        result2.append("\n");
        result2.append("For terms of use, see the licence below.\n");
        result2.append("\n");
        result2.append("FURTHER INFORMATION:");
        result2.append(this.getInfo());
        result2.append("\n");
        result2.append("CONTRIBUTORS:");
        if (this.contributors != null) {
            Iterator iterator = this.contributors.iterator();
            while (iterator.hasNext()) {
                Contributor contributor = (Contributor)iterator.next();
                result2.append(contributor.getName());
                result2.append(" (");
                result2.append(contributor.getEmail());
                result2.append(").");
            }
        } else {
            result2.append("None");
        }
        result2.append("\n");
        result2.append("OTHER LIBRARIES USED BY ");
        result2.append(this.getName());
        result2.append(":");
        Library[] libraries = this.getLibraries();
        if (libraries.length != 0) {
            int i = 0;
            while (i < libraries.length) {
                Library lib = libraries[i];
                result2.append(lib.getName());
                result2.append(" ");
                result2.append(lib.getVersion());
                result2.append(" (");
                result2.append(lib.getInfo());
                result2.append(").");
                ++i;
            }
        } else {
            result2.append("None");
        }
        result2.append("\n");
        result2.append(this.getName());
        result2.append(" LICENCE TERMS:");
        result2.append("\n");
        result2.append(this.getLicenceText());
        return result2.toString();
    }
}

