/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.jfree.util.Log;

public class ActionMenuItem
extends JMenuItem {
    private Action action;
    private ActionEnablePropertyChangeHandler propertyChangeHandler;

    public ActionMenuItem() {
    }

    public ActionMenuItem(String text) {
        super(text);
    }

    public ActionMenuItem(String text, int i) {
        super(text, i);
    }

    public ActionMenuItem(String text, Icon icon) {
        super(text, icon);
    }

    public ActionMenuItem(Action action) {
        this.setAction(action);
    }

    public ActionMenuItem(Icon icon) {
        super(icon);
    }

    public Action getAction() {
        return this.action;
    }

    private ActionEnablePropertyChangeHandler getPropertyChangeHandler() {
        if (this.propertyChangeHandler == null) {
            this.propertyChangeHandler = new ActionEnablePropertyChangeHandler();
        }
        return this.propertyChangeHandler;
    }

    public void setAction(Action newAction) {
        KeyStroke k;
        Object o;
        Action oldAction = this.getAction();
        if (oldAction != null) {
            this.removeActionListener(oldAction);
            oldAction.removePropertyChangeListener(this.getPropertyChangeHandler());
            o = oldAction.getValue("AcceleratorKey");
            if (o instanceof KeyStroke && o != null) {
                k = (KeyStroke)o;
                this.unregisterKeyboardAction(k);
            }
        }
        this.action = newAction;
        if (this.action != null) {
            this.addActionListener(newAction);
            newAction.addPropertyChangeListener(this.getPropertyChangeHandler());
            this.setText((String)newAction.getValue("Name"));
            this.setToolTipText((String)newAction.getValue("ShortDescription"));
            this.setIcon((Icon)newAction.getValue("SmallIcon"));
            this.setEnabled(this.action.isEnabled());
            o = newAction.getValue("MnemonicKey");
            if (o != null) {
                Comparable<Character> c2;
                if (o instanceof Character) {
                    c2 = (Character)o;
                    this.setMnemonic(((Character)c2).charValue());
                } else if (o instanceof Integer) {
                    c2 = (Integer)o;
                    this.setMnemonic((Integer)c2);
                }
            }
            if ((o = newAction.getValue("AcceleratorKey")) instanceof KeyStroke && o != null) {
                k = (KeyStroke)o;
                this.registerKeyboardAction(newAction, k, 2);
            }
        }
    }

    public void setEnabled(boolean b2) {
        super.setEnabled(b2);
        if (this.getAction() != null) {
            this.getAction().setEnabled(b2);
        }
    }

    private class ActionEnablePropertyChangeHandler
    implements PropertyChangeListener {
        ActionEnablePropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            try {
                Object o;
                if (event.getPropertyName().equals("enabled")) {
                    ActionMenuItem.this.setEnabled(ActionMenuItem.this.getAction().isEnabled());
                } else if (event.getPropertyName().equals("SmallIcon")) {
                    ActionMenuItem.this.setIcon((Icon)ActionMenuItem.this.getAction().getValue("SmallIcon"));
                } else if (event.getPropertyName().equals("Name")) {
                    ActionMenuItem.this.setText((String)ActionMenuItem.this.getAction().getValue("Name"));
                } else if (event.getPropertyName().equals("ShortDescription")) {
                    ActionMenuItem.this.setToolTipText((String)ActionMenuItem.this.getAction().getValue("ShortDescription"));
                }
                Action ac = ActionMenuItem.this.getAction();
                if (event.getPropertyName().equals("AcceleratorKey")) {
                    Object o2;
                    KeyStroke oldVal = (KeyStroke)event.getOldValue();
                    if (oldVal != null) {
                        ActionMenuItem.this.unregisterKeyboardAction(oldVal);
                    }
                    if ((o2 = ac.getValue("AcceleratorKey")) instanceof KeyStroke && o2 != null) {
                        KeyStroke k = (KeyStroke)o2;
                        ActionMenuItem.this.registerKeyboardAction(ac, k, 2);
                    }
                } else if (event.getPropertyName().equals("MnemonicKey") && (o = ac.getValue("MnemonicKey")) != null) {
                    if (o instanceof Character) {
                        Character c2 = (Character)o;
                        ActionMenuItem.this.setMnemonic(c2.charValue());
                    } else if (o instanceof Integer) {
                        Integer c3 = (Integer)o;
                        ActionMenuItem.this.setMnemonic(c3);
                    }
                }
            }
            catch (Exception e) {
                Log.warn("Error on PropertyChange in ActionButton: ", e);
            }
        }
    }
}

