/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util;

import java.util.Arrays;

public class ArrayUtilities {
    private ArrayUtilities() {
    }

    public static float[][] clone(float[][] array) {
        if (array == null) {
            return null;
        }
        float[][] result2 = new float[array.length][];
        System.arraycopy(array, 0, result2, 0, array.length);
        int i = 0;
        while (i < array.length) {
            float[] child = array[i];
            float[] copychild = new float[child.length];
            System.arraycopy(child, 0, copychild, 0, child.length);
            result2[i] = copychild;
            ++i;
        }
        return result2;
    }

    public static boolean equal(float[][] array1, float[][] array2) {
        if (array1 == null) {
            return array2 == null;
        }
        if (array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        int i = 0;
        while (i < array1.length) {
            if (!Arrays.equals(array1[i], array2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equalReferencesInArrays(Object[] array1, Object[] array2) {
        if (array1 == null) {
            return array2 == null;
        }
        if (array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        int i = 0;
        while (i < array1.length) {
            if (array1[i] == null && array2[i] != null) {
                return false;
            }
            if (array2[i] == null && array1[i] != null) {
                return false;
            }
            if (array1[i] != array2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean hasDuplicateItems(Object[] array) {
        int i = 0;
        while (i < array.length) {
            int j = 0;
            while (j < i) {
                Object o1 = array[i];
                Object o2 = array[j];
                if (o1 != null && o2 != null && o1.equals(o2)) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }
}

