/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import org.jfree.util.Log;
import org.jfree.util.PublicCloneable;

public final class ObjectUtilities {
    public static final String THREAD_CONTEXT = "ThreadContext";
    public static final String CLASS_CONTEXT = "ClassContext";
    private static String classLoaderSource = "ThreadContext";
    private static ClassLoader classLoader;

    private ObjectUtilities() {
    }

    public static Object clone(Object object) throws CloneNotSupportedException {
        if (object == null) {
            throw new IllegalArgumentException("Null 'object' argument.");
        }
        if (object instanceof PublicCloneable) {
            PublicCloneable pc = (PublicCloneable)object;
            return pc.clone();
        }
        try {
            Method method = object.getClass().getMethod("clone", null);
            if (Modifier.isPublic(method.getModifiers())) {
                return method.invoke(object, null);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Log.warn("Object without clone() method is impossible.");
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.warn("Object.clone(): unable to call method.");
        }
        catch (InvocationTargetException invocationTargetException) {
            Log.warn("Object without clone() method is impossible.");
        }
        throw new CloneNotSupportedException("Failed to clone.");
    }

    /*
     * Unable to fully structure code
     */
    private static String convertName(String name, Class c) {
        if (!name.startsWith("/")) ** GOTO lbl4
        return name.substring(1);
lbl-1000:
        // 1 sources

        {
            c = c.getComponentType();
lbl4:
            // 2 sources

            ** while (c.isArray())
        }
lbl5:
        // 1 sources

        baseName = c.getName();
        index = baseName.lastIndexOf(46);
        if (index == -1) {
            return name;
        }
        pkgName = baseName.substring(0, index);
        return String.valueOf(pkgName.replace('.', '/')) + "/" + name;
    }

    public static Collection deepClone(Collection collection) throws CloneNotSupportedException {
        if (collection == null) {
            throw new IllegalArgumentException("Null 'collection' argument.");
        }
        Collection result2 = (Collection)ObjectUtilities.clone(collection);
        result2.clear();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object item = iterator.next();
            if (item != null) {
                result2.add(ObjectUtilities.clone(item));
                continue;
            }
            result2.add(null);
        }
        return result2;
    }

    public static boolean equal(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 != null) {
            return o1.equals(o2);
        }
        return false;
    }

    public static synchronized ClassLoader getClassLoader(Class c2) {
        if (classLoader != null) {
            return classLoader;
        }
        if (THREAD_CONTEXT.equals(classLoaderSource)) {
            ClassLoader threadLoader = Thread.currentThread().getContextClassLoader();
            return threadLoader;
        }
        ClassLoader applicationCL = c2.getClassLoader();
        if (applicationCL == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return applicationCL;
    }

    public static String getClassLoaderSource() {
        return classLoaderSource;
    }

    public static URL getResource(String name, Class c2) {
        ClassLoader cl = ObjectUtilities.getClassLoader(c2);
        return cl.getResource(name);
    }

    public static InputStream getResourceAsStream(String name, Class context) {
        URL url = ObjectUtilities.getResource(name, context);
        if (url == null) {
            return null;
        }
        try {
            return url.openStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static URL getResourceRelative(String name, Class c2) {
        ClassLoader cl = ObjectUtilities.getClassLoader(c2);
        String cname = ObjectUtilities.convertName(name, c2);
        return cl.getResource(cname);
    }

    public static InputStream getResourceRelativeAsStream(String name, Class context) {
        URL url = ObjectUtilities.getResourceRelative(name, context);
        if (url == null) {
            return null;
        }
        try {
            return url.openStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static int hashCode(Object object) {
        int result2 = 0;
        if (object != null) {
            result2 = object.hashCode();
        }
        return result2;
    }

    public static Object loadAndInstantiate(String className, Class source) {
        try {
            ClassLoader loader = ObjectUtilities.getClassLoader(source);
            Class<?> c2 = loader.loadClass(className);
            return c2.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static synchronized void setClassLoader(ClassLoader classLoader) {
        ObjectUtilities.classLoader = classLoader;
    }

    public static void setClassLoaderSource(String classLoaderSource) {
        ObjectUtilities.classLoaderSource = classLoaderSource;
    }
}

