/*
 * Decompiled with CFR 0.152.
 */
package org.jgap;

import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.jgap.Chromosome;
import org.jgap.Gene;

public abstract class Allele
implements Comparable {
    private Long id;
    private Gene gene;
    private Chromosome chromosome = null;

    protected Allele() {
    }

    protected Allele(Gene aGene) {
        this.gene = aGene;
    }

    public abstract double distance(Allele var1);

    public abstract void setToRandomValue(Random var1);

    public abstract Allele cloneAllele();

    protected Gene getGene() {
        return this.gene;
    }

    private void setGene(Gene aGene) {
        this.gene = aGene;
    }

    private Long getId() {
        return this.id;
    }

    private void setId(Long aId) {
        this.id = aId;
    }

    public int compareTo(Object o) {
        Allele other = (Allele)o;
        return this.gene.compareTo(other.gene);
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public int hashCode() {
        return this.gene.hashCode();
    }

    public String toString() {
        StringBuffer result2 = new StringBuffer();
        result2.append(this.gene.toString());
        if (this.id != null) {
            result2.append("[").append(this.id).append("]");
        }
        return result2.toString();
    }

    public static Set getGenes(Collection alleles) {
        HashSet<Gene> result2 = new HashSet<Gene>();
        for (Allele allele : alleles) {
            result2.add(allele.getGene());
        }
        return result2;
    }

    public Long getInnovationId() {
        return this.gene.getInnovationId();
    }

    private Chromosome getChromosome() {
        return this.chromosome;
    }

    void setChromosome(Chromosome aChromosome) {
        this.chromosome = aChromosome;
    }
}

