/*
 * Decompiled with CFR 0.152.
 */
package org.jgap;

import java.io.Serializable;
import java.util.Collections;
import java.util.SortedSet;
import org.jgap.Allele;
import org.jgap.ChromosomeMaterial;
import org.jgap.SpeciationParms;
import org.jgap.Specie;

public class Chromosome
implements Comparable,
Serializable {
    public static final Long DEFAULT_ID = new Long(-1L);
    private Long m_id = DEFAULT_ID;
    private String m_idString;
    private ChromosomeMaterial m_material = null;
    private SortedSet m_alleles = null;
    protected boolean m_isSelectedForNextGeneration = false;
    protected int m_fitnessValue = -1;
    private Specie m_specie = null;

    private Chromosome() {
        this.m_material = new ChromosomeMaterial();
    }

    public Chromosome(ChromosomeMaterial a_material, Long an_id) {
        if (a_material == null) {
            throw new IllegalArgumentException("Chromosome material can't be null.");
        }
        this.setId(an_id);
        this.m_material = a_material;
        this.m_alleles = Collections.unmodifiableSortedSet(this.m_material.getAlleles());
        this.associateAllelesWithChromosome();
    }

    private void associateAllelesWithChromosome() {
        for (Allele allele : this.m_alleles) {
            allele.setChromosome(this);
        }
    }

    public double distance(Chromosome target, SpeciationParms parms) {
        return this.m_material.distance(target.m_material, parms);
    }

    public Long getId() {
        return this.m_id;
    }

    private void setId(Long id) {
        this.m_id = id;
        this.m_idString = "Chromosome " + this.m_id;
    }

    public int size() {
        return this.m_alleles.size();
    }

    public ChromosomeMaterial cloneMaterial() {
        return this.m_material.clone(this.getId());
    }

    public SortedSet getAlleles() {
        return this.m_alleles;
    }

    public Allele findMatchingGene(Allele alleleToMatch) {
        for (Allele allele : this.m_alleles) {
            if (!allele.equals(alleleToMatch)) continue;
            return allele;
        }
        return null;
    }

    public int getFitnessValue() {
        return this.m_fitnessValue;
    }

    public int getSpeciatedFitnessValue() {
        if (this.m_specie == null) {
            return this.getFitnessValue();
        }
        int result2 = (int)(this.m_specie.getChromosomeFitnessValue(this) + 0.5);
        return result2 == 0 ? 1 : result2;
    }

    public void setFitnessValue(int a_newFitnessValue) {
        this.m_fitnessValue = a_newFitnessValue > 0 ? a_newFitnessValue : 1;
    }

    public String toString() {
        return this.m_idString;
    }

    public boolean equals(Object other) {
        return this.compareTo(other) == 0;
    }

    public int hashCode() {
        return this.m_id.hashCode();
    }

    public int compareTo(Object o) {
        Chromosome other = (Chromosome)o;
        return this.m_id.compareTo(other.m_id);
    }

    public void setIsSelectedForNextGeneration(boolean a_isSelected) {
        this.m_isSelectedForNextGeneration = a_isSelected;
    }

    public boolean isSelectedForNextGeneration() {
        return this.m_isSelectedForNextGeneration;
    }

    void setSpecie(Specie aSpecie) {
        if (this.m_specie != null) {
            throw new IllegalStateException("chromosome can't be added to " + aSpecie + ", already a member of specie " + this.m_specie);
        }
        this.m_specie = aSpecie;
    }

    private void setPrimaryParentId(Long id) {
        this.m_material.setPrimaryParentId(id);
    }

    private void setSecondaryParentId(Long id) {
        this.m_material.setSecondaryParentId(id);
    }

    public Specie getSpecie() {
        return this.m_specie;
    }

    public Long getPrimaryParentId() {
        return this.m_material.getPrimaryParentId();
    }

    public Long getSecondaryParentId() {
        return this.m_material.getSecondaryParentId();
    }

    private void setAlleles(SortedSet aAlleles) {
        this.m_material.setAlleles(aAlleles);
        this.m_alleles = Collections.unmodifiableSortedSet(aAlleles);
        this.associateAllelesWithChromosome();
    }

    public void importMaterial(ChromosomeMaterial chromMat) {
        this.m_material = chromMat;
    }
}

