/*
 * Decompiled with CFR 0.152.
 */
package org.jgap;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jgap.Allele;
import org.jgap.Configuration;
import org.jgap.InvalidConfigurationException;
import org.jgap.SpeciationParms;

public class ChromosomeMaterial
implements Comparable,
Serializable {
    private Long primaryParentId = null;
    private Long secondaryParentId = null;
    private SortedSet m_alleles = null;

    public ChromosomeMaterial(Collection a_initialAlleles, Long aPrimaryParentId, Long aSecondaryParentId) {
        if (a_initialAlleles == null) {
            throw new IllegalArgumentException("The given List of alleles cannot be null.");
        }
        this.setPrimaryParentId(aPrimaryParentId);
        this.setSecondaryParentId(aSecondaryParentId);
        Iterator iter = a_initialAlleles.iterator();
        while (iter.hasNext()) {
            if (iter.next() != null) continue;
            throw new IllegalArgumentException("The given List of alleles cannot contain nulls.");
        }
        this.m_alleles = new TreeSet(a_initialAlleles);
    }

    public ChromosomeMaterial(Collection a_initialGenes, Long aPrimaryParentId) {
        this(a_initialGenes, aPrimaryParentId, null);
    }

    public ChromosomeMaterial(Collection a_initialAlleles) {
        this(a_initialAlleles, null, null);
    }

    ChromosomeMaterial() {
        this(new TreeSet(), null, null);
    }

    public ChromosomeMaterial clone(Long parentId) {
        ArrayList<Allele> copyOfAlleles = new ArrayList<Allele>(this.m_alleles.size());
        for (Allele orig : this.m_alleles) {
            copyOfAlleles.add(orig.cloneAllele());
        }
        Long cloneParentId = parentId == null ? this.getPrimaryParentId() : parentId;
        return new ChromosomeMaterial(copyOfAlleles, cloneParentId);
    }

    public SortedSet getAlleles() {
        return this.m_alleles;
    }

    public String toString() {
        Allele allele;
        StringBuffer representation = new StringBuffer();
        representation.append("[ ");
        Iterator iter = this.m_alleles.iterator();
        if (iter.hasNext()) {
            allele = (Allele)iter.next();
            representation.append(allele.toString());
        }
        while (iter.hasNext()) {
            allele = (Allele)iter.next();
            representation.append(", ");
            representation.append(allele.toString());
        }
        representation.append(" ]");
        return representation.toString();
    }

    public static ChromosomeMaterial randomInitialChromosomeMaterial(Configuration a_activeConfiguration) throws InvalidConfigurationException {
        if (a_activeConfiguration == null) {
            throw new IllegalArgumentException("Configuration instance must not be null");
        }
        a_activeConfiguration.lockSettings();
        ChromosomeMaterial newMaterial = a_activeConfiguration.getSampleChromosomeMaterial().clone(null);
        for (Allele newAllele : newMaterial.getAlleles()) {
            newAllele.setToRandomValue(a_activeConfiguration.getRandomGenerator());
        }
        return newMaterial;
    }

    public boolean equals(Object other) {
        return this.compareTo(other) == 0;
    }

    public int compareTo(Object other) {
        if (other == null) {
            return 1;
        }
        ChromosomeMaterial otherChromosome = (ChromosomeMaterial)other;
        SortedSet otherAlleles = otherChromosome.m_alleles;
        if (otherAlleles.size() != this.m_alleles.size()) {
            return this.m_alleles.size() - otherAlleles.size();
        }
        Iterator iter = this.m_alleles.iterator();
        Iterator otherIter = otherAlleles.iterator();
        while (iter.hasNext() && otherIter.hasNext()) {
            Class<?> targetClass;
            Allele allele = (Allele)iter.next();
            Allele otherAllele = (Allele)otherIter.next();
            Class<?> srcClass = allele.getClass();
            if (srcClass != (targetClass = otherAllele.getClass())) {
                return srcClass.getName().compareTo(targetClass.getName());
            }
            int comparison = allele.compareTo(otherAllele);
            if (comparison == 0) continue;
            return comparison;
        }
        return 0;
    }

    public Long getPrimaryParentId() {
        return this.primaryParentId;
    }

    public Long getSecondaryParentId() {
        return this.secondaryParentId;
    }

    void setPrimaryParentId(Long id) {
        if (this.primaryParentId != null) {
            throw new IllegalStateException("can not set primary parent ID twice");
        }
        this.primaryParentId = id;
    }

    public void setSecondaryParentId(Long id) {
        if (this.secondaryParentId != null) {
            throw new IllegalStateException("can not set secondary parent ID twice");
        }
        this.secondaryParentId = id;
    }

    private static long getMaxInnovationId(Collection someAlleles) {
        long result2 = -1L;
        for (Allele allele : someAlleles) {
            if (allele.getInnovationId() <= result2) continue;
            result2 = allele.getInnovationId();
        }
        return result2;
    }

    private List extractExcessAlleles(Collection alleles, long threshold) {
        ArrayList<Allele> result2 = new ArrayList<Allele>();
        Iterator iter = alleles.iterator();
        while (iter.hasNext()) {
            Allele allele = (Allele)iter.next();
            if (allele.getInnovationId() <= threshold) continue;
            iter.remove();
            result2.add(allele);
        }
        return result2;
    }

    public double distance(ChromosomeMaterial target, SpeciationParms speciationParms) {
        ArrayList myUnmatchedAlleles = new ArrayList(this.m_alleles);
        myUnmatchedAlleles.removeAll(target.getAlleles());
        ArrayList targetUnmatchedAlleles = new ArrayList(target.getAlleles());
        targetUnmatchedAlleles.removeAll(this.m_alleles);
        long targetMax = ChromosomeMaterial.getMaxInnovationId(target.getAlleles());
        long thisMax = ChromosomeMaterial.getMaxInnovationId(this.m_alleles);
        List excessAlleles = targetMax > thisMax ? this.extractExcessAlleles(targetUnmatchedAlleles, thisMax) : this.extractExcessAlleles(myUnmatchedAlleles, targetMax);
        ArrayList disjointAlleles = new ArrayList(myUnmatchedAlleles);
        disjointAlleles.addAll(targetUnmatchedAlleles);
        ArrayList myCommonAlleles = new ArrayList(this.getAlleles());
        myCommonAlleles.retainAll(target.getAlleles());
        ArrayList targetCommonAlleles = new ArrayList(target.getAlleles());
        targetCommonAlleles.retainAll(this.getAlleles());
        if (myCommonAlleles.size() != targetCommonAlleles.size()) {
            throw new IllegalStateException("sizes of my common genes and target common genes differ");
        }
        double avgCommonDiff = 0.0;
        int numComparableCommonAlleles = 0;
        if (myCommonAlleles.size() > 0) {
            double totalCommonDiff = 0.0;
            Iterator myIter = myCommonAlleles.iterator();
            Iterator targetIter = targetCommonAlleles.iterator();
            while (myIter.hasNext() && targetIter.hasNext() && totalCommonDiff < Double.MAX_VALUE) {
                Allele myAllele = (Allele)myIter.next();
                Allele targetAllele = (Allele)targetIter.next();
                if (!myAllele.getInnovationId().equals(targetAllele.getInnovationId())) {
                    throw new IllegalStateException("corresponding genes do not have same innovation ids");
                }
                try {
                    double aDistance = myAllele.distance(targetAllele);
                    totalCommonDiff = totalCommonDiff + aDistance > Double.MAX_VALUE ? Double.MAX_VALUE : (totalCommonDiff += aDistance);
                    ++numComparableCommonAlleles;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
            avgCommonDiff = totalCommonDiff / (double)numComparableCommonAlleles;
        }
        long maxChromSize = Math.max(this.getAlleles().size(), target.getAlleles().size());
        double result2 = 0.0;
        if (maxChromSize > 0L) {
            result2 = speciationParms.getSpecieCompatExcessCoeff() * (double)excessAlleles.size() / (double)maxChromSize + speciationParms.getSpecieCompatDisjointCoeff() * (double)disjointAlleles.size() / (double)maxChromSize + speciationParms.getSpecieCompatCommonCoeff() * avgCommonDiff;
        }
        return result2;
    }

    void setAlleles(SortedSet aAlleles) {
        this.m_alleles = aAlleles;
    }
}

