/*
 * Decompiled with CFR 0.152.
 */
package org.jgap;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.jgap.BulkFitnessFunction;
import org.jgap.ChromosomeMaterial;
import org.jgap.FitnessFunction;
import org.jgap.IdFactory;
import org.jgap.InvalidConfigurationException;
import org.jgap.MutationOperator;
import org.jgap.NaturalSelector;
import org.jgap.ReproductionOperator;
import org.jgap.SpeciationParms;
import org.jgap.event.EventManager;

public class Configuration
implements Serializable {
    private IdFactory idFactory = new IdFactory();
    private FitnessFunction m_objectiveFunction = null;
    private BulkFitnessFunction m_bulkObjectiveFunction = null;
    private NaturalSelector m_populationSelector = null;
    private SpeciationParms m_speciationParms = new SpeciationParms();
    private ChromosomeMaterial m_sampleChromosomeMaterial = null;
    private Random m_randomGenerator = null;
    private EventManager m_eventManager = null;
    private List reproductionOperators = new ArrayList();
    private List mutationOperators = new ArrayList();
    private int m_populationSize = 0;
    private boolean m_settingsLocked = false;

    public Long nextChromosomeId() {
        return new Long(this.idFactory.next());
    }

    public Long nextInnovationId() {
        return new Long(this.idFactory.next());
    }

    public synchronized void setNaturalSelector(NaturalSelector selector) throws InvalidConfigurationException {
        this.verifyChangesAllowed();
        this.m_populationSelector = selector;
    }

    public NaturalSelector getNaturalSelector() {
        return this.m_populationSelector;
    }

    public synchronized void addReproductionOperator(ReproductionOperator a_operatorToAdd) throws InvalidConfigurationException {
        this.verifyChangesAllowed();
        if (a_operatorToAdd == null) {
            throw new InvalidConfigurationException("ReproductionOperator instance may not be null.");
        }
        this.reproductionOperators.add(a_operatorToAdd);
    }

    public List getReproductionOperators() {
        return this.reproductionOperators;
    }

    public synchronized void addMutationOperator(MutationOperator a_operatorToAdd) throws InvalidConfigurationException {
        this.verifyChangesAllowed();
        if (a_operatorToAdd == null) {
            throw new InvalidConfigurationException("ReproductionOperator instance may not be null.");
        }
        this.mutationOperators.add(a_operatorToAdd);
    }

    public List getMutationOperators() {
        return this.mutationOperators;
    }

    public synchronized void setFitnessFunction(FitnessFunction a_functionToSet) throws InvalidConfigurationException {
        this.verifyChangesAllowed();
        if (a_functionToSet == null) {
            throw new InvalidConfigurationException("The FitnessFunction instance may not be null.");
        }
        if (this.m_bulkObjectiveFunction != null) {
            throw new InvalidConfigurationException("The bulk fitness function and normal fitness function may not both be set.");
        }
        this.m_objectiveFunction = a_functionToSet;
    }

    public FitnessFunction getFitnessFunction() {
        return this.m_objectiveFunction;
    }

    public synchronized void setBulkFitnessFunction(BulkFitnessFunction a_functionToSet) throws InvalidConfigurationException {
        this.verifyChangesAllowed();
        if (a_functionToSet == null) {
            throw new InvalidConfigurationException("The BulkFitnessFunction instance may not be null.");
        }
        if (this.m_objectiveFunction != null) {
            throw new InvalidConfigurationException("The bulk fitness function and normal fitness function may not both be set.");
        }
        this.m_bulkObjectiveFunction = a_functionToSet;
    }

    public BulkFitnessFunction getBulkFitnessFunction() {
        return this.m_bulkObjectiveFunction;
    }

    public void setSampleChromosomeMaterial(ChromosomeMaterial a_sampleChromosomeMaterial) throws InvalidConfigurationException {
        this.verifyChangesAllowed();
        if (a_sampleChromosomeMaterial == null) {
            throw new InvalidConfigurationException("The sample Chromosome instance may not be null.");
        }
        this.m_sampleChromosomeMaterial = a_sampleChromosomeMaterial;
    }

    public ChromosomeMaterial getSampleChromosomeMaterial() {
        return this.m_sampleChromosomeMaterial;
    }

    public synchronized void setRandomGenerator(Random a_generatorToSet) throws InvalidConfigurationException {
        this.verifyChangesAllowed();
        if (a_generatorToSet == null) {
            throw new InvalidConfigurationException("The RandomGenerator instance may not be null.");
        }
        this.m_randomGenerator = a_generatorToSet;
    }

    public Random getRandomGenerator() {
        return this.m_randomGenerator;
    }

    public synchronized void setPopulationSize(int a_sizeOfPopulation) throws InvalidConfigurationException {
        this.verifyChangesAllowed();
        if (a_sizeOfPopulation < 1) {
            throw new InvalidConfigurationException("The population size must be positive.");
        }
        this.m_populationSize = a_sizeOfPopulation;
    }

    public int getPopulationSize() {
        return this.m_populationSize;
    }

    public void setEventManager(EventManager a_eventManagerToSet) throws InvalidConfigurationException {
        this.verifyChangesAllowed();
        if (a_eventManagerToSet == null) {
            throw new InvalidConfigurationException("The EventManager instance may not be null.");
        }
        this.m_eventManager = a_eventManagerToSet;
    }

    public EventManager getEventManager() {
        return this.m_eventManager;
    }

    public synchronized void lockSettings() throws InvalidConfigurationException {
        if (!this.m_settingsLocked) {
            this.verifyStateIsValid();
            this.reproductionOperators = Collections.unmodifiableList(this.reproductionOperators);
            this.mutationOperators = Collections.unmodifiableList(this.mutationOperators);
            this.m_settingsLocked = true;
        }
    }

    public boolean isLocked() {
        return this.m_settingsLocked;
    }

    public synchronized void verifyStateIsValid() throws InvalidConfigurationException {
        if (this.m_objectiveFunction == null && this.m_bulkObjectiveFunction == null) {
            throw new InvalidConfigurationException("A desired fitness function or bulk fitness function must be specified in the active configuration.");
        }
        if (this.m_sampleChromosomeMaterial == null) {
            throw new InvalidConfigurationException("Sample ChromosomeMaterial setup must be specified in the active configuration.");
        }
        if (this.m_populationSelector == null) {
            throw new InvalidConfigurationException("A desired natural selector must be specified in the active configuration.");
        }
        if (this.m_randomGenerator == null) {
            throw new InvalidConfigurationException("A desired random number generator must be specified in the active configuration.");
        }
        if (this.m_eventManager == null) {
            throw new InvalidConfigurationException("A desired event manager must be specified in the active configuration.");
        }
        if (this.reproductionOperators.isEmpty()) {
            throw new InvalidConfigurationException("At least one reproduction operator must be specified in the configuration.");
        }
        float totalSlices = this.getNaturalSelector().getSurvivalRate();
        for (ReproductionOperator oper : this.getReproductionOperators()) {
            totalSlices += oper.getSlice();
        }
        if (totalSlices != 1.0f) {
            throw new InvalidConfigurationException("Survival rate and reproduction rates are more than 1.0f.");
        }
        if (this.m_populationSize <= 0) {
            throw new InvalidConfigurationException("A genotype size greater than zero must be specified in the active configuration.");
        }
    }

    protected void verifyChangesAllowed() throws InvalidConfigurationException {
        if (this.m_settingsLocked) {
            throw new InvalidConfigurationException("This Configuration object is locked. Settings may not be altered.");
        }
    }

    public IdFactory getIdFactory() {
        return this.idFactory;
    }

    public void setIdFactory(IdFactory factory) {
        this.idFactory = factory;
    }

    public SpeciationParms getSpeciationParms() {
        return this.m_speciationParms;
    }
}

