/*
 * Decompiled with CFR 0.152.
 */
package org.jgap;

import java.util.List;
import org.jgap.Chromosome;
import org.jgap.ChromosomeMaterial;
import org.jgap.Configuration;
import org.jgap.ReproductionOperator;
import org.jgap.impl.CloneReproductionOperator;

public abstract class CrossoverReproductionOperator
extends ReproductionOperator {
    protected abstract ChromosomeMaterial reproduce(Configuration var1, Chromosome var2, Chromosome var3);

    @Override
    protected final void reproduce(Configuration config, List parentChroms, int numOffspring, List offspring) {
        if (parentChroms.size() < 1) {
            throw new IllegalArgumentException("crossover requires at least 1 parent");
        }
        if (parentChroms.size() < 2) {
            CloneReproductionOperator.reproduce(parentChroms, numOffspring, offspring);
        } else {
            int targetSize = offspring.size() + numOffspring;
            while (offspring.size() < targetSize) {
                int motherIdx;
                int fatherIdx = motherIdx = config.getRandomGenerator().nextInt(parentChroms.size());
                while (fatherIdx == motherIdx) {
                    fatherIdx = config.getRandomGenerator().nextInt(parentChroms.size());
                }
                Chromosome dominant = null;
                Chromosome recessive = null;
                Chromosome mother = (Chromosome)parentChroms.get(motherIdx);
                Chromosome father = (Chromosome)parentChroms.get(fatherIdx);
                if (mother.getFitnessValue() > father.getFitnessValue()) {
                    dominant = mother;
                    recessive = father;
                } else {
                    recessive = mother;
                    dominant = father;
                }
                ChromosomeMaterial child = this.reproduce(config, dominant, recessive);
                offspring.add(child);
            }
        }
    }
}

