/*
 * Decompiled with CFR 0.152.
 */
package org.jgap;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jgap.BulkFitnessFunction;
import org.jgap.Chromosome;
import org.jgap.ChromosomeMaterial;
import org.jgap.Configuration;
import org.jgap.FitnessFunction;
import org.jgap.InvalidConfigurationException;
import org.jgap.MutationOperator;
import org.jgap.NaturalSelector;
import org.jgap.ReproductionOperator;
import org.jgap.Specie;
import org.jgap.event.GeneticEvent;

public class Genotype
implements Serializable {
    protected Configuration m_activeConfiguration;
    protected List m_species = new ArrayList();
    protected List m_chromosomes = new ArrayList();

    public Genotype(Configuration a_activeConfiguration, List a_initialChromosomes) throws InvalidConfigurationException {
        if (a_activeConfiguration == null) {
            throw new IllegalArgumentException("The Configuration instance may not be null.");
        }
        if (a_initialChromosomes == null) {
            throw new IllegalArgumentException("The array of Chromosomes may not be null.");
        }
        int i = 0;
        while (i < a_initialChromosomes.size()) {
            if (a_initialChromosomes.get(i) == null) {
                throw new IllegalArgumentException("The Chromosome instance at index " + i + " of the array of " + "Chromosomes is null. No instance in this array may be null.");
            }
            ++i;
        }
        a_activeConfiguration.lockSettings();
        this.m_activeConfiguration = a_activeConfiguration;
        this.adjustChromosomeList(a_initialChromosomes, a_activeConfiguration.getPopulationSize());
        this.addChromosomes(a_initialChromosomes);
    }

    private void adjustChromosomeList(List chroms, int targetSize) {
        ArrayList originals = new ArrayList(chroms);
        while (chroms.size() < targetSize) {
            int idx = chroms.size() % originals.size();
            Chromosome orig = (Chromosome)originals.get(idx);
            Chromosome clone = new Chromosome(orig.cloneMaterial(), this.m_activeConfiguration.nextChromosomeId());
            chroms.add(clone);
        }
        while (chroms.size() > targetSize) {
            chroms.remove(chroms.size() - 1);
        }
    }

    protected void addChromosomes(Collection chromosomes) {
        for (Chromosome c2 : chromosomes) {
            this.addChromosome(c2);
        }
    }

    protected void addChromosomesFromMaterial(Collection chromosomeMaterial) {
        for (ChromosomeMaterial cMat : chromosomeMaterial) {
            this.addChromosomeFromMaterial(cMat);
        }
    }

    protected void addChromosomeFromMaterial(ChromosomeMaterial cMat) {
        Chromosome chrom = new Chromosome(cMat, this.m_activeConfiguration.nextChromosomeId());
        this.addChromosome(chrom);
    }

    protected void addChromosome(Chromosome chrom) {
        this.m_chromosomes.add(chrom);
        boolean added = false;
        Specie specie = null;
        Iterator iter = this.m_species.iterator();
        while (iter.hasNext() && !added) {
            specie = (Specie)iter.next();
            if (!specie.match(chrom)) continue;
            specie.add(chrom);
            added = true;
        }
        if (!added) {
            specie = new Specie(this.m_activeConfiguration.getSpeciationParms(), chrom);
            this.m_species.add(specie);
        }
    }

    public synchronized List getChromosomes() {
        return this.m_chromosomes;
    }

    public synchronized List getSpecies() {
        return this.m_species;
    }

    public synchronized Chromosome getFittestChromosome() {
        if (this.getChromosomes().isEmpty()) {
            return null;
        }
        Iterator iter = this.getChromosomes().iterator();
        Chromosome fittestChromosome = (Chromosome)iter.next();
        int fittestValue = fittestChromosome.getFitnessValue();
        while (iter.hasNext()) {
            Chromosome chrom = (Chromosome)iter.next();
            if (chrom.getFitnessValue() <= fittestValue) continue;
            fittestChromosome = chrom;
            fittestValue = fittestChromosome.getFitnessValue();
        }
        return fittestChromosome;
    }

    public synchronized void evolve() {
        try {
            this.m_activeConfiguration.lockSettings();
            BulkFitnessFunction bulkFunction = this.m_activeConfiguration.getBulkFitnessFunction();
            if (bulkFunction != null) {
                bulkFunction.evaluate(this.m_chromosomes);
            } else {
                FitnessFunction function = this.m_activeConfiguration.getFitnessFunction();
                for (Chromosome c2 : this.m_chromosomes) {
                    c2.setFitnessValue(function.getFitnessValue(c2));
                }
            }
            this.m_activeConfiguration.getEventManager().fireGeneticEvent(new GeneticEvent("genotype_evaluated_event", this));
            NaturalSelector selector = this.m_activeConfiguration.getNaturalSelector();
            selector.add(this.m_activeConfiguration, this.m_chromosomes);
            this.m_chromosomes = selector.select(this.m_activeConfiguration);
            selector.empty();
            Iterator speciesIter = this.m_species.iterator();
            while (speciesIter.hasNext()) {
                Specie s = (Specie)speciesIter.next();
                s.cull(this.m_chromosomes);
                if (!s.isEmpty()) continue;
                speciesIter.remove();
            }
            this.m_activeConfiguration.getEventManager().fireGeneticEvent(new GeneticEvent("genotype_start_genetic_operators_event", this));
            Iterator iterator = this.m_activeConfiguration.getReproductionOperators().iterator();
            ArrayList offspring = new ArrayList();
            while (iterator.hasNext()) {
                ReproductionOperator operator = (ReproductionOperator)iterator.next();
                operator.reproduce(this.m_activeConfiguration, this.m_species, offspring);
            }
            for (MutationOperator operator : this.m_activeConfiguration.getMutationOperators()) {
                operator.mutate(this.m_activeConfiguration, offspring);
            }
            Collections.shuffle(offspring, this.m_activeConfiguration.getRandomGenerator());
            this.adjustChromosomeList(offspring, this.m_activeConfiguration.getPopulationSize() - this.m_chromosomes.size());
            System.out.println("Genotype.evolve.replacing " + offspring.size() + " brains");
            this.addChromosomesFromMaterial(offspring);
            this.m_activeConfiguration.getEventManager().fireGeneticEvent(new GeneticEvent("genotype_finish_genetic_operators_event", this));
            this.m_activeConfiguration.getEventManager().fireGeneticEvent(new GeneticEvent("genotype_evolved_event", this));
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException("bad config", e);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (Chromosome chrom : this.m_chromosomes) {
            buffer.append(chrom.toString());
            buffer.append(" [");
            buffer.append(chrom.getFitnessValue());
            buffer.append(']');
            buffer.append('\n');
        }
        return buffer.toString();
    }

    public static Genotype randomInitialGenotype(Configuration a_activeConfiguration) throws InvalidConfigurationException {
        if (a_activeConfiguration == null) {
            throw new IllegalArgumentException("The Configuration instance may not be null.");
        }
        a_activeConfiguration.lockSettings();
        int populationSize = a_activeConfiguration.getPopulationSize();
        ArrayList<Chromosome> chroms = new ArrayList<Chromosome>(populationSize);
        int i = 0;
        while (i < populationSize) {
            ChromosomeMaterial material = ChromosomeMaterial.randomInitialChromosomeMaterial(a_activeConfiguration);
            chroms.add(new Chromosome(material, a_activeConfiguration.nextChromosomeId()));
            ++i;
        }
        return new Genotype(a_activeConfiguration, chroms);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object other) {
        try {
            Chromosome otherChrom;
            Chromosome chrom;
            if (other == null) {
                return false;
            }
            Genotype otherGenotype = (Genotype)other;
            if (this.m_chromosomes.size() != otherGenotype.m_chromosomes.size()) {
                return false;
            }
            Collections.sort(this.m_chromosomes);
            Collections.sort(otherGenotype.m_chromosomes);
            Iterator iter = this.m_chromosomes.iterator();
            Iterator otherIter = otherGenotype.m_chromosomes.iterator();
            do {
                if (iter.hasNext() && otherIter.hasNext()) continue;
                return true;
            } while ((chrom = (Chromosome)iter.next()).equals(otherChrom = (Chromosome)otherIter.next()));
            return false;
        }
        catch (ClassCastException e) {
            return false;
        }
    }
}

