/*
 * Decompiled with CFR 0.152.
 */
package org.jgap;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class IdFactory {
    public static final long DEFAULT_BASE_ID = 0L;
    public static final String XML_TAG = "id";
    private long nextId = 0L;
    private String fileName = null;

    public long next() {
        return this.nextId++;
    }

    public IdFactory() {
    }

    public IdFactory(String aFileName) throws IOException {
        this.fileName = aFileName;
        try (FileInputStream in = null;){
            File f = new File(aFileName);
            if (f.exists()) {
                in = new FileInputStream(this.fileName);
                this.nextId = IdFactory.fromXml(in);
            }
        }
    }

    private static long fromXml(InputStream in) throws IllegalArgumentException {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(in);
            Node node = doc.getFirstChild();
            if (!XML_TAG.equals(node.getNodeName())) {
                throw new IllegalArgumentException("tag != id");
            }
            if ((node = node.getFirstChild()) == null) {
                throw new IllegalArgumentException("empty id node");
            }
            String aNextIdStr = node.getNodeValue();
            if (aNextIdStr == null || aNextIdStr.length() == 0) {
                throw new IllegalArgumentException("empty id");
            }
            long id = Long.parseLong(aNextIdStr);
            return id;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("xml does not parse: " + e.getMessage());
        }
    }

    public String toString() {
        return this.toXml();
    }

    public String toXml() {
        StringBuffer result2 = new StringBuffer();
        result2.append("<id>").append(this.nextId).append("</id>");
        return result2.toString();
    }

    public void store() throws IOException {
        if (this.fileName != null) {
            try (FileWriter out = null;){
                out = new FileWriter(this.fileName);
                out.write(this.toXml());
                out.flush();
            }
        }
    }
}

