/*
 * Decompiled with CFR 0.152.
 */
package org.jgap;

import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.Set;
import org.jgap.ChromosomeMaterial;
import org.jgap.Configuration;
import org.jgap.InvalidConfigurationException;

public abstract class MutationOperator {
    private float mutationRate = 0.0f;

    public MutationOperator(float aMutationRate) {
        this.mutationRate = aMutationRate;
    }

    protected abstract void mutate(Configuration var1, ChromosomeMaterial var2, Set var3, Set var4) throws InvalidConfigurationException;

    public void mutate(Configuration config, List offspring) throws InvalidConfigurationException {
        ListIterator iter = offspring.listIterator();
        while (iter.hasNext()) {
            ChromosomeMaterial material = (ChromosomeMaterial)iter.next();
            HashSet allelesToAdd = new HashSet();
            HashSet allelesToRemove = new HashSet();
            this.mutate(config, material, allelesToAdd, allelesToRemove);
            MutationOperator.updateMaterial(material, allelesToAdd, allelesToRemove);
        }
    }

    protected int numMutations(Random rand, int numOpportunities) {
        int result2 = 0;
        if (this.getMutationRate() > 0.0f) {
            int i = 0;
            while (i < numOpportunities) {
                if (this.doesMutationOccur(rand)) {
                    ++result2;
                }
                ++i;
            }
        }
        return result2;
    }

    protected boolean doesMutationOccur(Random rand) {
        return MutationOperator.doesMutationOccur(rand, this.getMutationRate());
    }

    protected static boolean doesMutationOccur(Random rand, float mutationRate) {
        return rand.nextDouble() < (double)mutationRate;
    }

    public float getMutationRate() {
        return this.mutationRate;
    }

    protected static void updateMaterial(ChromosomeMaterial material, Set allelesToAdd, Set allelesToRemove) {
        material.getAlleles().removeAll(allelesToRemove);
        material.getAlleles().addAll(allelesToAdd);
    }

    protected void setMutationRate(float aMutationRate) {
        this.mutationRate = aMutationRate;
    }
}

