/*
 * Decompiled with CFR 0.152.
 */
package org.jgap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jgap.Chromosome;
import org.jgap.ChromosomeFitnessComparator;
import org.jgap.Configuration;
import org.jgap.Specie;

public abstract class NaturalSelector {
    private float survivalRate = 0.0f;
    private int numChromosomes = 0;
    private boolean elitism = false;
    private int elitismMinSpecieSize = 6;
    private List elite = new ArrayList();

    public final void add(Configuration config, List chroms) {
        this.numChromosomes += chroms.size();
        for (Chromosome c2 : chroms) {
            Specie specie = c2.getSpecie();
            if (this.elitism && specie != null && specie.getChromosomes().size() >= this.getElitismMinSpecieSize() && specie.getFittest().equals(c2)) {
                c2.setIsSelectedForNextGeneration(true);
                this.elite.add(c2);
                continue;
            }
            this.add(config, c2);
        }
    }

    protected abstract void add(Configuration var1, Chromosome var2);

    public List select(Configuration config) {
        ArrayList result2 = new ArrayList(this.elite);
        int numToSelect = (int)((double)((float)this.numChromosomes * this.getSurvivalRate()) + 0.5);
        if (numToSelect == 0) {
            numToSelect = 1;
        }
        if (result2.size() > numToSelect) {
            Collections.sort(result2, new ChromosomeFitnessComparator(true, false));
            int numToRemove = result2.size() - numToSelect;
            int i = 0;
            while (i < numToRemove) {
                result2.remove(0);
                ++i;
            }
        } else if (result2.size() < numToSelect) {
            int moreToSelect = numToSelect - result2.size();
            List more = this.select(config, moreToSelect);
            result2.addAll(more);
        }
        return result2;
    }

    protected abstract List select(Configuration var1, int var2);

    public void empty() {
        this.numChromosomes = 0;
        this.elite.clear();
        this.emptyImpl();
    }

    protected abstract void emptyImpl();

    public float getSurvivalRate() {
        return this.survivalRate;
    }

    public void setSurvivalRate(float aSurvivalRate) {
        if ((double)aSurvivalRate < 0.0 || (double)aSurvivalRate > 1.0) {
            throw new IllegalArgumentException("0.0 <= survivalRate <= 1.0");
        }
        this.survivalRate = aSurvivalRate;
    }

    public int getElitismMinSpecieSize() {
        return this.elitismMinSpecieSize;
    }

    public void setElitismMinSpecieSize(int i) {
        this.elitismMinSpecieSize = i;
    }

    public void setElitism(boolean b2) {
        this.elitism = b2;
    }
}

