/*
 * Decompiled with CFR 0.152.
 */
package org.jgap;

import java.util.ArrayList;
import java.util.List;
import org.jgap.ChromosomeMaterial;
import org.jgap.Configuration;
import org.jgap.InvalidConfigurationException;
import org.jgap.Specie;

public abstract class ReproductionOperator {
    private float slice = 0.0f;

    public final void reproduce(Configuration config, List parentSpecies, List offspring) throws InvalidConfigurationException {
        int targetNewOffspringCount = (int)((double)((float)config.getPopulationSize() * this.getSlice()) + 0.5);
        if (targetNewOffspringCount > 0) {
            if (parentSpecies.isEmpty()) {
                throw new IllegalStateException("no parent species from which to product offspring");
            }
            ArrayList<ChromosomeMaterial> newOffspring = new ArrayList<ChromosomeMaterial>(targetNewOffspringCount);
            double totalSpeciesFitness = 0.0;
            for (Specie specie : parentSpecies) {
                totalSpeciesFitness += specie.getFitnessValue();
            }
            for (Specie specie : parentSpecies) {
                double percentFitness = specie.getFitnessValue() / totalSpeciesFitness;
                int numSpecieOffspring = (int)(percentFitness * (double)targetNewOffspringCount + 0.5);
                this.reproduce(config, specie.getChromosomes(), numSpecieOffspring, newOffspring);
            }
            while (newOffspring.size() > targetNewOffspringCount) {
                int idx = config.getRandomGenerator().nextInt(newOffspring.size());
                newOffspring.remove(idx);
            }
            while (newOffspring.size() < targetNewOffspringCount) {
                int idx = config.getRandomGenerator().nextInt(newOffspring.size());
                ChromosomeMaterial clonee = (ChromosomeMaterial)newOffspring.get(idx);
                newOffspring.add(clonee.clone(null));
            }
            offspring.addAll(newOffspring);
        }
    }

    protected abstract void reproduce(Configuration var1, List var2, int var3, List var4) throws InvalidConfigurationException;

    public final float getSlice() {
        return this.slice;
    }

    public final void setSlice(float aSlice) {
        this.slice = aSlice;
    }
}

