/*
 * Decompiled with CFR 0.152.
 */
package org.jgap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jgap.Chromosome;
import org.jgap.SpeciationParms;

public class Specie {
    public static final String SPECIE_TAG = "specie";
    public static final String ID_TAG = "id";
    public static final String COUNT_TAG = "count";
    public static final String CHROMOSOME_TAG = "chromosome";
    public static final String FITNESS_TAG = "fitness";
    private List chromosomes = new ArrayList();
    private Chromosome representative = null;
    private SpeciationParms speciationParms = null;
    private Chromosome fittest = null;
    private Long id;

    public int hashCode() {
        return this.representative.hashCode();
    }

    public boolean equals(Object o) {
        Specie other = (Specie)o;
        return this.representative.equals(other.representative);
    }

    public Long getRepresentativeId() {
        return this.representative.getId();
    }

    public Specie(SpeciationParms aSpeciationParms, Chromosome aRepresentative) {
        this.representative = aRepresentative;
        aRepresentative.setSpecie(this);
        this.chromosomes.add(aRepresentative);
        this.speciationParms = aSpeciationParms;
    }

    protected Chromosome getRepresentative() {
        return this.representative;
    }

    public boolean add(Chromosome aChromosome) {
        if (!this.match(aChromosome)) {
            throw new IllegalArgumentException("chromosome does not match specie: " + aChromosome);
        }
        if (this.chromosomes.contains(aChromosome)) {
            return false;
        }
        aChromosome.setSpecie(this);
        this.fittest = null;
        return this.chromosomes.add(aChromosome);
    }

    public List getChromosomes() {
        return Collections.unmodifiableList(this.chromosomes);
    }

    public void cull(Collection keepers) {
        this.fittest = null;
        this.chromosomes.retainAll(keepers);
    }

    public boolean isEmpty() {
        return this.chromosomes.isEmpty();
    }

    public double getChromosomeFitnessValue(Chromosome aChromosome) {
        if (aChromosome.getFitnessValue() < 0) {
            throw new IllegalArgumentException("chromosome's fitness has not been set: " + aChromosome.toString());
        }
        if (!this.chromosomes.contains(aChromosome)) {
            throw new IllegalArgumentException("chromosome not a member of this specie: " + aChromosome.toString());
        }
        return (double)aChromosome.getFitnessValue() / (double)this.chromosomes.size();
    }

    public double getFitnessValue() {
        long totalRawFitness = 0L;
        for (Chromosome aChromosome : this.chromosomes) {
            if (aChromosome.getFitnessValue() < 0) {
                throw new IllegalStateException("chromosome's fitness has not been set: " + aChromosome.toString());
            }
            totalRawFitness += (long)aChromosome.getFitnessValue();
        }
        return (double)totalRawFitness / (double)this.chromosomes.size();
    }

    public synchronized Chromosome getFittest() {
        if (this.fittest == null) {
            Iterator it = this.chromosomes.iterator();
            this.fittest = (Chromosome)it.next();
            while (it.hasNext()) {
                Chromosome next = (Chromosome)it.next();
                if (next.getFitnessValue() <= this.fittest.getFitnessValue()) continue;
                this.fittest = next;
            }
        }
        return this.fittest;
    }

    public boolean match(Chromosome aChromosome) {
        return this.representative.distance(aChromosome, this.speciationParms) < this.speciationParms.getSpeciationThreshold();
    }

    public String toString() {
        StringBuffer result2 = new StringBuffer("Specie ");
        result2.append(this.getRepresentativeId());
        return result2.toString();
    }

    public String toXml() {
        StringBuffer result2 = new StringBuffer();
        result2.append("<").append(SPECIE_TAG).append(" ").append(ID_TAG).append("=\"");
        result2.append(this.getRepresentativeId()).append("\" ").append(COUNT_TAG).append("=\"");
        result2.append(this.getChromosomes().size()).append("\">\n");
        for (Chromosome chromToStore : this.getChromosomes()) {
            result2.append("<").append(CHROMOSOME_TAG).append(" ").append(ID_TAG).append("=\"");
            result2.append(chromToStore.getId()).append("\" ").append(FITNESS_TAG).append("=\"");
            result2.append(chromToStore.getFitnessValue()).append("\" />\n");
        }
        result2.append("</").append(SPECIE_TAG).append(">\n");
        return result2.toString();
    }

    private Long getId() {
        return this.id;
    }

    private void setId(Long aId) {
        this.id = aId;
    }
}

