/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import java.util.Random;
import org.jgap.Allele;
import org.jgap.Configuration;
import org.jgap.Gene;
import org.jgap.UnsupportedRepresentationException;

public class BooleanAllele
extends Allele {
    protected static final Boolean TRUE_BOOLEAN = new Boolean(true);
    protected static final Boolean FALSE_BOOLEAN = new Boolean(false);
    protected Boolean m_value = null;
    protected Configuration m_activeConfiguration = null;

    public BooleanAllele() {
        this(new Long(0L));
    }

    public BooleanAllele(Long an_id) {
        super(new Gene(an_id));
    }

    private BooleanAllele(Gene gene) {
        super(gene);
    }

    @Override
    public Allele cloneAllele() {
        BooleanAllele result2 = new BooleanAllele(this.getGene());
        result2.setValue(this.m_value);
        return result2;
    }

    public void setValue(Object a_newValue) {
        this.m_value = (Boolean)a_newValue;
    }

    public String getPersistentRepresentation() throws UnsupportedOperationException {
        return this.toString();
    }

    public void setValueFromPersistentRepresentation(String a_representation) throws UnsupportedRepresentationException {
        if (a_representation != null) {
            if (a_representation.equals("null")) {
                this.m_value = null;
            } else if (a_representation.equals("true")) {
                this.m_value = TRUE_BOOLEAN;
            } else if (a_representation.equals("false")) {
                this.m_value = FALSE_BOOLEAN;
            } else {
                throw new UnsupportedRepresentationException("Unknown boolean gene representation: " + a_representation);
            }
        }
    }

    public boolean booleanValue() {
        return this.m_value;
    }

    @Override
    public void setToRandomValue(Random a_numberGenerator) {
        this.m_value = a_numberGenerator.nextBoolean() ? TRUE_BOOLEAN : FALSE_BOOLEAN;
    }

    @Override
    public boolean equals(Object other) {
        try {
            return this.compareTo(other) == 0;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        if (this.m_value == null) {
            return 0;
        }
        return this.m_value.hashCode();
    }

    @Override
    public String toString() {
        if (this.m_value == null) {
            return "null";
        }
        return this.m_value.toString();
    }

    public void cleanup() {
    }

    @Override
    public double distance(Allele target) {
        return 0.0;
    }
}

