/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import java.util.Random;
import java.util.StringTokenizer;
import org.jgap.Allele;
import org.jgap.Configuration;
import org.jgap.Gene;
import org.jgap.UnsupportedRepresentationException;

public class IntegerAllele
extends Allele {
    protected static final long INTEGER_RANGE = 0xFFFFFFFFL;
    protected static final String PERSISTENT_FIELD_DELIMITER = ":";
    protected Integer m_value = null;
    protected int m_upperBounds;
    protected int m_lowerBounds;
    protected long m_boundsUnitsToIntegerUnits;
    protected Configuration m_activeConfiguration = null;

    public String toXml() {
        StringBuffer result2 = new StringBuffer();
        result2.append("<IntegerGene value=\"").append(this.m_value).append("\"/>");
        return result2.toString();
    }

    @Override
    public double distance(Allele target) {
        if (target.getInnovationId().equals(this.getInnovationId()) && target instanceof IntegerAllele) {
            return Math.abs(this.intValue() - ((IntegerAllele)target).intValue());
        }
        return Double.MAX_VALUE;
    }

    public IntegerAllele() {
        this(null, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public IntegerAllele(int a_lowerBounds, int a_upperBounds) {
        this(null, a_lowerBounds, a_upperBounds);
    }

    public IntegerAllele(Configuration a_activeConfiguration) {
        this(a_activeConfiguration, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    private IntegerAllele(Gene gene) {
        super(gene);
        this.m_lowerBounds = Integer.MIN_VALUE;
        this.m_upperBounds = Integer.MAX_VALUE;
        this.calculateBoundsUnitsToIntegerUnitsRatio();
    }

    public IntegerAllele(Configuration a_activeConfiguration, int a_lowerBounds, int a_upperBounds) {
        super(new Gene(a_activeConfiguration == null ? new Long(0L) : a_activeConfiguration.nextInnovationId()));
        this.m_activeConfiguration = a_activeConfiguration;
        this.m_lowerBounds = a_lowerBounds;
        this.m_upperBounds = a_upperBounds;
        this.calculateBoundsUnitsToIntegerUnitsRatio();
    }

    public Allele newAllele(Configuration a_activeConfiguration) {
        return new IntegerAllele(a_activeConfiguration, this.m_lowerBounds, this.m_upperBounds);
    }

    @Override
    public Allele cloneAllele() {
        IntegerAllele result2 = new IntegerAllele(this.getGene());
        result2.setValue(this.m_value);
        return result2;
    }

    public void setValue(Integer a_newValue) {
        this.m_value = a_newValue;
        this.mapValueToWithinBounds();
    }

    public Integer getValue() {
        return this.m_value;
    }

    public String getPersistentRepresentation() throws UnsupportedOperationException {
        return String.valueOf(this.toString()) + PERSISTENT_FIELD_DELIMITER + this.m_lowerBounds + PERSISTENT_FIELD_DELIMITER + this.m_upperBounds;
    }

    public void setValueFromPersistentRepresentation(String a_representation) throws UnsupportedRepresentationException {
        if (a_representation != null) {
            StringTokenizer tokenizer = new StringTokenizer(a_representation, PERSISTENT_FIELD_DELIMITER);
            if (tokenizer.countTokens() != 3) {
                throw new UnsupportedRepresentationException("The format of the given persistent representation is not recognized: it does not contain three tokens.");
            }
            String valueRepresentation = tokenizer.nextToken();
            String lowerBoundRepresentation = tokenizer.nextToken();
            String upperBoundRepresentation = tokenizer.nextToken();
            if (valueRepresentation.equals("null")) {
                this.m_value = null;
            } else {
                try {
                    this.m_value = new Integer(Integer.parseInt(valueRepresentation));
                }
                catch (NumberFormatException e) {
                    throw new UnsupportedRepresentationException("The format of the given persistent representation is not recognized: field 1 does not appear to be an integer value.");
                }
            }
            try {
                this.m_lowerBounds = Integer.parseInt(lowerBoundRepresentation);
            }
            catch (NumberFormatException e) {
                throw new UnsupportedRepresentationException("The format of the given persistent representation is not recognized: field 2 does not appear to be an integer value.");
            }
            try {
                this.m_upperBounds = Integer.parseInt(upperBoundRepresentation);
            }
            catch (NumberFormatException e) {
                throw new UnsupportedRepresentationException("The format of the given persistent representation is not recognized: field 3 does not appear to be an integer value.");
            }
            this.calculateBoundsUnitsToIntegerUnitsRatio();
        }
    }

    public int intValue() {
        return this.m_value;
    }

    @Override
    public void setToRandomValue(Random a_numberGenerator) {
        this.m_value = new Integer(a_numberGenerator.nextInt());
        this.mapValueToWithinBounds();
    }

    @Override
    public int hashCode() {
        if (this.m_value == null) {
            return 0;
        }
        return this.m_value.hashCode();
    }

    @Override
    public String toString() {
        if (this.m_value == null) {
            return "null";
        }
        return this.getInnovationId() + PERSISTENT_FIELD_DELIMITER + this.m_value.toString();
    }

    public void cleanup() {
    }

    protected void mapValueToWithinBounds() {
        if (this.m_value != null && (this.m_value > this.m_upperBounds || this.m_value < this.m_lowerBounds)) {
            long differenceFromIntMin = Integer.MIN_VALUE + (long)this.m_value.intValue();
            int differenceFromBoundsMin = (int)(differenceFromIntMin / this.m_boundsUnitsToIntegerUnits);
            this.m_value = new Integer(this.m_upperBounds + differenceFromBoundsMin);
        }
    }

    protected void calculateBoundsUnitsToIntegerUnitsRatio() {
        int divisor = this.m_upperBounds - this.m_lowerBounds + 1;
        this.m_boundsUnitsToIntegerUnits = divisor == 0 ? 0xFFFFFFFFL : 0xFFFFFFFFL / (long)divisor;
    }
}

