/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.jgap.Chromosome;
import org.jgap.Configuration;
import org.jgap.NaturalSelector;
import org.jgap.impl.Pool;
import org.jgap.impl.SlotCounter;

public class WeightedRouletteSelector
extends NaturalSelector {
    private Map m_wheel = new HashMap();
    private long m_totalNumberOfUsedSlots = 0L;
    private Pool m_counterPool = new Pool();

    @Override
    protected synchronized void add(Configuration a_activeConfigurator, Chromosome a_chromosomeToAdd) {
        SlotCounter counter = (SlotCounter)this.m_wheel.get(a_chromosomeToAdd);
        if (counter != null) {
            counter.incrementByFitness();
        } else {
            a_chromosomeToAdd.setIsSelectedForNextGeneration(false);
            counter = (SlotCounter)this.m_counterPool.acquirePooledObject();
            if (counter == null) {
                counter = new SlotCounter();
            }
            counter.reset(a_chromosomeToAdd.getSpeciatedFitnessValue());
            this.m_wheel.put(a_chromosomeToAdd, counter);
        }
        this.m_totalNumberOfUsedSlots += (long)a_chromosomeToAdd.getSpeciatedFitnessValue();
    }

    @Override
    protected synchronized List select(Configuration a_activeConfiguration, int a_howManyToSelect) {
        ArrayList<Chromosome> result2 = new ArrayList<Chromosome>();
        if (!this.m_wheel.isEmpty()) {
            Random generator = a_activeConfiguration.getRandomGenerator();
            Set entries = this.m_wheel.entrySet();
            int numberOfEntries = entries.size();
            int[] fitnessValues = new int[numberOfEntries];
            long[] counterValues = new long[numberOfEntries];
            Chromosome[] chromosomes = new Chromosome[numberOfEntries];
            Iterator entryIterator = entries.iterator();
            int i = 0;
            while (i < numberOfEntries) {
                Map.Entry chromosomeEntry = entryIterator.next();
                Chromosome currentChromosome = (Chromosome)chromosomeEntry.getKey();
                SlotCounter currentCounter = (SlotCounter)chromosomeEntry.getValue();
                fitnessValues[i] = currentCounter.getFitnessValue();
                counterValues[i] = currentCounter.getCounterValue();
                chromosomes[i] = currentChromosome;
                ++i;
            }
            while (result2.size() < a_howManyToSelect) {
                Chromosome selectedChromosome = this.spinWheel(generator, fitnessValues, counterValues, chromosomes);
                selectedChromosome.setIsSelectedForNextGeneration(true);
                result2.add(selectedChromosome);
            }
        }
        return result2;
    }

    private Chromosome spinWheel(Random a_generator, int[] a_fitnessValues, long[] a_counterValues, Chromosome[] a_chromosomes) {
        long selectedSlot = Math.abs(a_generator.nextLong() % this.m_totalNumberOfUsedSlots);
        long currentSlot = 0L;
        int i = 0;
        while (i < a_counterValues.length) {
            if ((currentSlot += a_counterValues[i]) > selectedSlot) {
                int n = i;
                a_counterValues[n] = a_counterValues[n] - (long)a_fitnessValues[i];
                this.m_totalNumberOfUsedSlots -= (long)a_fitnessValues[i];
                return a_chromosomes[i];
            }
            ++i;
        }
        long totalSlotsLeft = 0L;
        int i2 = 0;
        while (i2 < a_counterValues.length) {
            totalSlotsLeft += a_counterValues[i2];
            ++i2;
        }
        throw new RuntimeException("Logic Error. This code should never be reached. Please report this as a bug to the JGAP team: selected slot " + selectedSlot + " " + "exceeded " + totalSlotsLeft + " number of slots left.");
    }

    @Override
    protected synchronized void emptyImpl() {
        this.m_counterPool.releaseAllObjects(this.m_wheel.values());
        this.m_wheel.clear();
        this.m_totalNumberOfUsedSlots = 0L;
    }
}

