/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.util.Arrays;
import org.json.JSONException;

public class Kim {
    private byte[] bytes = null;
    private int hashcode = 0;
    public int length = 0;
    private String string = null;

    public Kim(byte[] bytes, int from, int thru) {
        int sum = 1;
        this.hashcode = 0;
        this.length = thru - from;
        if (this.length > 0) {
            this.bytes = new byte[this.length];
            int at = 0;
            while (at < this.length) {
                int value = bytes[at + from] & 0xFF;
                this.hashcode += (sum += value);
                this.bytes[at] = (byte)value;
                ++at;
            }
            this.hashcode += sum << 16;
        }
    }

    public Kim(byte[] bytes, int length) {
        this(bytes, 0, length);
    }

    public Kim(Kim kim, int from, int thru) {
        this(kim.bytes, from, thru);
    }

    public Kim(String string) throws JSONException {
        int stringLength = string.length();
        this.hashcode = 0;
        this.length = 0;
        if (stringLength > 0) {
            int i = 0;
            while (i < stringLength) {
                char c2 = string.charAt(i);
                if (c2 <= '\u007f') {
                    ++this.length;
                } else if (c2 <= '\u3fff') {
                    this.length += 2;
                } else {
                    if (c2 >= '\ud800' && c2 <= '\udfff') {
                        char d = string.charAt(++i);
                        if (c2 > '\udbff' || d < '\udc00' || d > '\udfff') {
                            throw new JSONException("Bad UTF16");
                        }
                    }
                    this.length += 3;
                }
                ++i;
            }
            this.bytes = new byte[this.length];
            int at = 0;
            int sum = 1;
            int i2 = 0;
            while (i2 < stringLength) {
                int b2;
                int character = string.charAt(i2);
                if (character <= 127) {
                    this.bytes[at] = (byte)character;
                    this.hashcode += (sum += character);
                    ++at;
                } else if (character <= 16383) {
                    b2 = 0x80 | character >>> 7;
                    this.bytes[at] = (byte)b2;
                    this.hashcode += (sum += b2);
                    b2 = character & 0x7F;
                    this.bytes[++at] = (byte)b2;
                    this.hashcode += (sum += b2);
                    ++at;
                } else {
                    if (character >= 55296 && character <= 56319) {
                        character = ((character & 0x3FF) << 10 | string.charAt(++i2) & 0x3FF) + 65536;
                    }
                    b2 = 0x80 | character >>> 14;
                    this.bytes[at] = (byte)b2;
                    this.hashcode += (sum += b2);
                    b2 = 0x80 | character >>> 7 & 0xFF;
                    this.bytes[++at] = (byte)b2;
                    this.hashcode += (sum += b2);
                    b2 = character & 0x7F;
                    this.bytes[++at] = (byte)b2;
                    this.hashcode += (sum += b2);
                    ++at;
                }
                ++i2;
            }
            this.hashcode += sum << 16;
        }
    }

    public int characterAt(int at) throws JSONException {
        int c2 = this.get(at);
        if ((c2 & 0x80) == 0) {
            return c2;
        }
        int c1 = this.get(at + 1);
        if ((c1 & 0x80) == 0) {
            int character = (c2 & 0x7F) << 7 | c1;
            if (character > 127) {
                return character;
            }
        } else {
            int c22 = this.get(at + 2);
            int character = (c2 & 0x7F) << 14 | (c1 & 0x7F) << 7 | c22;
            if ((c22 & 0x80) == 0 && character > 16383 && character <= 0x10FFFF && (character < 55296 || character > 57343)) {
                return character;
            }
        }
        throw new JSONException("Bad character at " + at);
    }

    public static int characterSize(int character) throws JSONException {
        if (character < 0 || character > 0x10FFFF) {
            throw new JSONException("Bad character " + character);
        }
        return character <= 127 ? 1 : (character <= 16383 ? 2 : 3);
    }

    public int copy(byte[] bytes, int at) {
        System.arraycopy(this.bytes, 0, bytes, at, this.length);
        return at + this.length;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Kim)) {
            return false;
        }
        Kim that = (Kim)obj;
        if (this == that) {
            return true;
        }
        if (this.hashcode != that.hashcode) {
            return false;
        }
        return Arrays.equals(this.bytes, that.bytes);
    }

    public int get(int at) throws JSONException {
        if (at < 0 || at > this.length) {
            throw new JSONException("Bad character at " + at);
        }
        return this.bytes[at] & 0xFF;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public String toString() throws JSONException {
        if (this.string == null) {
            int length = 0;
            char[] chars = new char[this.length];
            int at = 0;
            while (at < this.length) {
                int c2 = this.characterAt(at);
                if (c2 < 65536) {
                    chars[length] = (char)c2;
                    ++length;
                } else {
                    chars[length] = (char)(0xD800 | c2 - 65536 >>> 10);
                    chars[++length] = (char)(0xDC00 | c2 & 0x3FF);
                    ++length;
                }
                at += Kim.characterSize(c2);
            }
            this.string = new String(chars, 0, length);
        }
        return this.string;
    }
}

