/*
 * Decompiled with CFR 0.152.
 */
package org.sqldroid;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.sqldroid.SQLDroidDriver;

public class DroidDataSource
implements DataSource {
    Connection connection = null;
    protected String description = "Android Sqlite Data Source";
    protected String packageName;
    protected String databaseName;

    public DroidDataSource() {
    }

    public DroidDataSource(String packageName, String databaseName) {
        this.setPackageName(packageName);
        this.setDatabaseName(databaseName);
    }

    @Override
    public Connection getConnection() throws SQLException {
        String url = "jdbc:sqldroid:/data/data/" + this.packageName + "/" + this.databaseName + ".db";
        this.connection = new SQLDroidDriver().connect(url, new Properties());
        return this.connection;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnection();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        PrintWriter logWriter = null;
        try {
            logWriter = new PrintWriter("droid.log");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return logWriter;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        try {
            DriverManager.setLogWriter(new PrintWriter("droid.log"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("isWrapperfor");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("unwrap");
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }
}

