/*
 * Decompiled with CFR 0.152.
 */
package org.sqldroid;

import android.database.SQLException;
import java.lang.reflect.Constructor;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.sqldroid.DebugPrinter;
import org.sqldroid.Log;
import org.sqldroid.SQLDroidDatabaseMetaData;
import org.sqldroid.SQLDroidDriver;
import org.sqldroid.SQLDroidPreparedStatement;
import org.sqldroid.SQLDroidStatement;
import org.sqldroid.SQLiteDatabase;

public class SQLDroidConnection
implements Connection {
    private static final Map<String, SQLiteDatabase> dbMap = new HashMap<String, SQLiteDatabase>();
    private static final Map<SQLDroidConnection, SQLiteDatabase> clientMap = new HashMap<SQLDroidConnection, SQLiteDatabase>();
    private SQLiteDatabase sqlitedb;
    private boolean autoCommit = true;
    protected static int sqlThrowable = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLDroidConnection(String url, Properties info) throws java.sql.SQLException {
        Log.v("SQLDroidConnection: " + Thread.currentThread().getId() + " \"" + Thread.currentThread().getName() + "\" " + this);
        Log.v("New sqlite jdbc from url '" + url + "', " + "'" + info + "'");
        String dbQname = url.startsWith(SQLDroidDriver.xerialPrefix) ? url.substring(SQLDroidDriver.xerialPrefix.length()) : url.substring(SQLDroidDriver.sqldroidPrefix.length());
        long timeout = 0L;
        long retryInterval = 50L;
        int queryPart = dbQname.indexOf(63);
        if (queryPart > 0) {
            dbQname = dbQname.substring(0, queryPart);
            String options = dbQname.substring(queryPart);
            while (options.length() > 0) {
                int optionEnd = options.indexOf(38);
                if (optionEnd == -1) {
                    optionEnd = options.length();
                }
                int equals = options.lastIndexOf(61, optionEnd);
                String optionName = options.substring(0, equals).trim();
                String optionValueString = options.substring(equals + 1, optionEnd).trim();
                try {
                    long optionValue = Long.parseLong(optionValueString);
                    if (optionName.equals("timeout")) {
                        timeout = optionValue;
                    } else if (optionName.equals("retry")) {
                        timeout = optionValue;
                        retryInterval = optionValue;
                    }
                    Log.v("Timeout: " + timeout);
                }
                catch (NumberFormatException nfe) {
                    Log.e("Error Parsing URL \"" + url + "\" Timeout String \"" + optionValueString + "\" is not a valid long", nfe);
                }
                options = options.substring(optionEnd + 1);
            }
        }
        Log.v("opening database " + dbQname);
        int flags = 0x10000010;
        if (info != null) {
            if (info.getProperty("DatabaseFlags") != null) {
                try {
                    flags = Integer.parseInt(info.getProperty("DatabaseFlags"));
                }
                catch (NumberFormatException nfe) {
                    Log.e("Error Parsing DatabaseFlags \"" + info.getProperty("DatabaseFlags") + " not a number ", nfe);
                }
            } else if (info != null && info.getProperty("AdditionalDatabaseFlags") != null) {
                try {
                    int extraFlags = Integer.parseInt(info.getProperty("AdditionalDatabaseFlags"));
                    flags |= extraFlags;
                }
                catch (NumberFormatException nfe) {
                    Log.e("Error Parsing DatabaseFlags \"" + info.getProperty("AdditionalDatabaseFlags") + " not a number ", nfe);
                }
            }
        }
        Map<String, SQLiteDatabase> map = dbMap;
        synchronized (map) {
            this.sqlitedb = dbMap.get(dbQname);
            if (this.sqlitedb == null) {
                Log.i("SQLDroidConnection: " + Thread.currentThread().getId() + " \"" + Thread.currentThread().getName() + "\" " + this + " Opening new database: " + dbQname);
                this.sqlitedb = new SQLiteDatabase(dbQname, timeout, retryInterval, flags);
                dbMap.put(dbQname, this.sqlitedb);
                clientMap.put(this, this.sqlitedb);
            }
        }
    }

    public SQLiteDatabase getDb() {
        return this.sqlitedb;
    }

    @Override
    public void clearWarnings() throws java.sql.SQLException {
    }

    public static java.sql.SQLException chainException(SQLException sqlException) {
        if (sqlThrowable < 0 || sqlThrowable >= 9) {
            try {
                sqlThrowable = 9;
                Constructor c2 = java.sql.SQLException.class.getDeclaredConstructor(Throwable.class);
                return (java.sql.SQLException)c2.newInstance(sqlException);
            }
            catch (Exception e) {
                sqlThrowable = 1;
            }
        }
        try {
            Constructor<?> c3 = SQLDroidConnection.class.getClassLoader().loadClass("org.sqldroid.SQLDroidSQLException").getDeclaredConstructor(SQLException.class);
            return (java.sql.SQLException)c3.newInstance(sqlException);
        }
        catch (Exception e) {
            return new java.sql.SQLException("Unable to Chain SQLException " + sqlException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws java.sql.SQLException {
        Log.v("SQLDroidConnection.close(): " + Thread.currentThread().getId() + " \"" + Thread.currentThread().getName() + "\" " + this);
        if (this.sqlitedb != null) {
            Map<String, SQLiteDatabase> map = dbMap;
            synchronized (map) {
                clientMap.remove(this);
                if (!clientMap.containsValue(this.sqlitedb)) {
                    Log.i("SQLDroidConnection.close(): " + Thread.currentThread().getId() + " \"" + Thread.currentThread().getName() + "\" " + this + " Closing the database since since last connection was closed.");
                    this.sqlitedb.close();
                    dbMap.remove(this.sqlitedb.dbQname);
                }
            }
            this.sqlitedb = null;
        } else {
            Log.e("SQLDroidConnection.close(): " + Thread.currentThread().getId() + " \"" + Thread.currentThread().getName() + "\" " + this + " Duplicate close!");
        }
    }

    @Override
    public void commit() throws java.sql.SQLException {
        if (this.autoCommit) {
            throw new java.sql.SQLException("database in auto-commit mode");
        }
        this.sqlitedb.setTransactionSuccessful();
        Log.d("END TRANSACTION  (commit) " + Thread.currentThread().getId() + " \"" + Thread.currentThread().getName() + "\" " + this);
        this.sqlitedb.endTransaction();
        Log.d("BEGIN TRANSACTION (after commit) " + Thread.currentThread().getId() + " \"" + Thread.currentThread().getName() + "\" " + this);
        this.sqlitedb.beginTransaction();
    }

    @Override
    public Statement createStatement() throws java.sql.SQLException {
        return new SQLDroidStatement(this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws java.sql.SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return null;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws java.sql.SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return null;
    }

    @Override
    public boolean getAutoCommit() throws java.sql.SQLException {
        return this.autoCommit;
    }

    @Override
    public String getCatalog() throws java.sql.SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return null;
    }

    @Override
    public int getHoldability() throws java.sql.SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return 0;
    }

    @Override
    public DatabaseMetaData getMetaData() throws java.sql.SQLException {
        return new SQLDroidDatabaseMetaData(this);
    }

    @Override
    public int getTransactionIsolation() throws java.sql.SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return 0;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws java.sql.SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return null;
    }

    @Override
    public SQLWarning getWarnings() throws java.sql.SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return null;
    }

    @Override
    public boolean isClosed() throws java.sql.SQLException {
        return this.sqlitedb == null || this.sqlitedb.getSqliteDatabase() == null || !this.sqlitedb.getSqliteDatabase().isOpen();
    }

    @Override
    public boolean isReadOnly() throws java.sql.SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return false;
    }

    @Override
    public String nativeSQL(String sql) throws java.sql.SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        this.sqlitedb.execSQL(sql);
        return "SQLDroid: no return info available from sqlite";
    }

    @Override
    public CallableStatement prepareCall(String sql) throws java.sql.SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws java.sql.SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws java.sql.SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws java.sql.SQLException {
        return new SQLDroidPreparedStatement(sql, this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws java.sql.SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws java.sql.SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws java.sql.SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws java.sql.SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws java.sql.SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return null;
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws java.sql.SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
    }

    @Override
    public void rollback() throws java.sql.SQLException {
        if (this.autoCommit) {
            throw new java.sql.SQLException("database in auto-commit mode");
        }
        Log.d("END TRANSACTION (rollback) " + Thread.currentThread().getId() + " \"" + Thread.currentThread().getName() + "\" " + this);
        this.sqlitedb.endTransaction();
        Log.d("BEGIN TRANSACTION (after rollback) " + Thread.currentThread().getId() + " \"" + Thread.currentThread().getName() + "\" " + this);
        this.sqlitedb.beginTransaction();
    }

    @Override
    public void rollback(Savepoint savepoint) throws java.sql.SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws java.sql.SQLException {
        if (this.autoCommit == autoCommit) {
            return;
        }
        this.autoCommit = autoCommit;
        if (autoCommit) {
            this.sqlitedb.setTransactionSuccessful();
            Log.d("END TRANSACTION (autocommit on) " + Thread.currentThread().getId() + " \"" + Thread.currentThread().getName() + "\" " + this);
            this.sqlitedb.endTransaction();
        } else {
            Log.d("BEGIN TRANSACTION (autocommit off) " + Thread.currentThread().getId() + " \"" + Thread.currentThread().getName() + "\" " + this);
            this.sqlitedb.beginTransaction();
        }
    }

    @Override
    public void setCatalog(String catalog) throws java.sql.SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
    }

    @Override
    public void setHoldability(int holdability) throws java.sql.SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
    }

    @Override
    public void setReadOnly(boolean readOnly) throws java.sql.SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
    }

    @Override
    public Savepoint setSavepoint() throws java.sql.SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return null;
    }

    @Override
    public Savepoint setSavepoint(String name) throws java.sql.SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return null;
    }

    @Override
    public void setTransactionIsolation(int level) throws java.sql.SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> arg0) throws java.sql.SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
    }

    protected void finalize() throws Throwable {
        Log.v(" --- Finalize SQLDroid.");
        if (!this.isClosed()) {
            this.close();
        }
        super.finalize();
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws java.sql.SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws java.sql.SQLException {
        return null;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws java.sql.SQLException {
        return null;
    }

    @Override
    public Blob createBlob() throws java.sql.SQLException {
        return null;
    }

    @Override
    public Clob createClob() throws java.sql.SQLException {
        return null;
    }

    @Override
    public NClob createNClob() throws java.sql.SQLException {
        return null;
    }

    @Override
    public SQLXML createSQLXML() throws java.sql.SQLException {
        return null;
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws java.sql.SQLException {
        return null;
    }

    @Override
    public Properties getClientInfo() throws java.sql.SQLException {
        return null;
    }

    @Override
    public String getClientInfo(String name) throws java.sql.SQLException {
        return null;
    }

    @Override
    public boolean isValid(int timeout) throws java.sql.SQLException {
        return false;
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws java.sql.SQLException {
    }

    @Override
    public int getNetworkTimeout() throws java.sql.SQLException {
        return 0;
    }

    @Override
    public void abort(Executor executor) throws java.sql.SQLException {
    }

    @Override
    public String getSchema() throws java.sql.SQLException {
        return null;
    }

    @Override
    public void setSchema(String schema) throws java.sql.SQLException {
    }
}

