/*
 * Decompiled with CFR 0.152.
 */
package org.sqldroid;

import android.database.Cursor;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import org.sqldroid.DebugPrinter;
import org.sqldroid.SQLDroidConnection;
import org.sqldroid.SQLDroidResultSet;
import org.sqldroid.SQLiteDatabase;

public class SQLDroidPreparedStatement
implements PreparedStatement {
    protected SQLiteDatabase db;
    protected SQLDroidConnection sqldroidConnection;
    protected SQLDroidResultSet rs = null;
    protected String sql;
    protected ArrayList<Object> l = new ArrayList();
    protected ArrayList<ArrayList<Object>> lBatch = new ArrayList();
    private Integer maxRows = null;
    protected boolean isSelect;
    protected boolean potentialResultSet;
    public int updateCount = -1;

    public SQLDroidPreparedStatement(String sql, SQLDroidConnection sqldroid) {
        Log.v((String)"SQLDRoid", (String)("new SqlDRoid prepared statement from " + sqldroid));
        this.sqldroidConnection = sqldroid;
        this.db = sqldroid.getDb();
        this.setSQL(sql);
    }

    private void ensureCap(int n) {
    }

    private void setObj(int n, Object obj) {
        int additions = --n - this.l.size() + 1;
        for (int i = 0; i < additions; ++i) {
            this.l.add(null);
        }
        this.l.set(n, obj);
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.setSQL(this.getSQL() + sql);
    }

    public String getSQL() {
        return this.sql;
    }

    public void setSQL(String sql) {
        this.sql = sql;
        this.isSelect = sql.toUpperCase().matches("(?m)(?s)\\s*SELECT.*");
        this.potentialResultSet = true;
        if (!this.isSelect && (sql.toUpperCase().matches("(?m)(?s)\\s*CREATE.*") || sql.toUpperCase().matches("(?m)(?s)\\s*DROP.*"))) {
            this.potentialResultSet = false;
        }
    }

    @Override
    public void cancel() throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
    }

    @Override
    public void clearBatch() throws SQLException {
        this.sql = "";
        this.lBatch = new ArrayList();
    }

    @Override
    public void clearWarnings() throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
    }

    @Override
    public void close() throws SQLException {
        try {
            if (this.rs != null) {
                this.rs.close();
            }
        }
        finally {
            this.rs = null;
        }
    }

    private String[] makeArgListQueryString() {
        if (this.l == null || this.l.size() == 0) {
            return new String[0];
        }
        ArrayList<String> strList = new ArrayList<String>();
        for (Object o : this.l) {
            strList.add(o.toString());
        }
        return strList.toArray(new String[1]);
    }

    private Object[] makeArgListQueryObject() {
        return this.l.toArray();
    }

    @Override
    public boolean execute() throws SQLException {
        this.updateCount = -1;
        this.closeResultSet();
        if (!this.isSelect && this.sql.toUpperCase().matches("(?m)(?s)\\s*PRAGMA.*")) {
            this.isSelect = true;
        }
        if (this.isSelect) {
            String limitedSql = this.sql + (this.maxRows != null ? " LIMIT " + this.maxRows : "");
            Cursor c2 = this.db.rawQuery(limitedSql, this.makeArgListQueryString());
            this.rs = new SQLDroidResultSet(c2);
        } else {
            this.db.execSQL(this.sql, this.makeArgListQueryObject());
            this.updateCount = this.db.changedRowCount();
        }
        return this.isSelect;
    }

    public void closeResultSet() throws SQLException {
        if (this.rs != null && !this.rs.isClosed()) {
            if (!this.rs.isClosed()) {
                this.rs.close();
            }
            this.rs = null;
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.updateCount = -1;
        this.closeResultSet();
        Cursor c2 = this.db.rawQuery(this.sql, this.makeArgListQueryString());
        this.rs = new SQLDroidResultSet(c2);
        return this.rs;
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.execute();
        return this.updateCount;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.setSQL(sql);
        return this.execute();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return false;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return false;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return false;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int[] results = new int[this.lBatch.size()];
        for (int i = 0; i < this.lBatch.size(); ++i) {
            this.updateCount = -1;
            results[i] = -3;
            this.db.execSQL(this.sql, this.lBatch.get(i).toArray());
            results[i] = this.db.changedRowCount();
            this.updateCount = results[i];
        }
        return results;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.setSQL(sql);
        return this.executeQuery();
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.setSQL(sql);
        return this.executeUpdate();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return 0;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return 0;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return 0;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.sqldroidConnection;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return 0;
    }

    @Override
    public int getFetchSize() throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return 0;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return null;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return 0;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        if (current == 1) {
            this.closeResultSet();
        }
        return false;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return 0;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.rs;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return 0;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return 0;
    }

    @Override
    public int getResultSetType() throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return 0;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.updateCount != -1) {
            int tmp = this.updateCount;
            this.updateCount = -1;
            return tmp;
        }
        return this.updateCount;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return null;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Statement is closed.");
        }
        if (max < 0) {
            throw new SQLException("Max rows must be zero or positive. Got " + max);
        }
        this.maxRows = max == 0 ? null : Integer.valueOf(max);
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
    }

    @Override
    public void addBatch() throws SQLException {
        int n = this.lBatch.size();
        this.lBatch.add(null);
        this.lBatch.set(n, this.l);
        this.clearParameters();
    }

    @Override
    public void clearParameters() throws SQLException {
        this.l = new ArrayList();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return null;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return null;
    }

    @Override
    public void setArray(int parameterIndex, Array theArray) throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream theInputStream, int length) throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal theBigDecimal) throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream inputStream, int length) throws SQLException {
        if (length <= 0) {
            throw new SQLException("Invalid length " + length);
        }
        if (inputStream == null) {
            throw new SQLException("Input Stream cannot be null");
        }
        int bufferSize = 8192;
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream outputStream = null;
        try {
            int maxReadSize;
            int bytesRead;
            outputStream = new ByteArrayOutputStream();
            for (int bytesRemaining = length; bytesRemaining > 0 && (bytesRead = inputStream.read(buffer, 0, maxReadSize = bytesRemaining > 8192 ? 8192 : bytesRemaining)) != -1; bytesRemaining -= bytesRead) {
                outputStream.write(buffer, 0, bytesRead);
            }
            this.setBytes(parameterIndex, outputStream.toByteArray());
            outputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public void setBlob(int parameterIndex, Blob theBlob) throws SQLException {
        this.ensureCap(parameterIndex);
        this.setObj(parameterIndex, theBlob.getBytes(1L, (int)theBlob.length()));
    }

    @Override
    public void setBoolean(int parameterIndex, boolean theBoolean) throws SQLException {
        this.ensureCap(parameterIndex);
        this.setObj(parameterIndex, theBoolean);
    }

    @Override
    public void setByte(int parameterIndex, byte theByte) throws SQLException {
        this.ensureCap(parameterIndex);
        this.setObj(parameterIndex, theByte);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] theBytes) throws SQLException {
        this.ensureCap(parameterIndex);
        this.setObj(parameterIndex, theBytes);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
    }

    @Override
    public void setClob(int parameterIndex, Clob theClob) throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
    }

    @Override
    public void setDate(int parameterIndex, Date theDate) throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
    }

    @Override
    public void setDate(int parameterIndex, Date theDate, Calendar cal) throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
    }

    @Override
    public void setDouble(int parameterIndex, double theDouble) throws SQLException {
        this.ensureCap(parameterIndex);
        this.setObj(parameterIndex, new Double(theDouble));
    }

    @Override
    public void setFloat(int parameterIndex, float theFloat) throws SQLException {
        this.ensureCap(parameterIndex);
        this.setObj(parameterIndex, new Double(theFloat));
    }

    @Override
    public void setInt(int parameterIndex, int theInt) throws SQLException {
        this.ensureCap(parameterIndex);
        this.setObj(parameterIndex, new Long(theInt));
    }

    @Override
    public void setLong(int parameterIndex, long theLong) throws SQLException {
        this.ensureCap(parameterIndex);
        this.setObj(parameterIndex, new Long(theLong));
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.ensureCap(parameterIndex);
        this.setObj(parameterIndex, null);
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.ensureCap(paramIndex);
        this.setObj(paramIndex, null);
    }

    @Override
    public void setObject(int parameterIndex, Object theObject) throws SQLException {
        this.ensureCap(parameterIndex);
        this.setObj(parameterIndex, theObject);
    }

    @Override
    public void setObject(int parameterIndex, Object theObject, int targetSqlType) throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
    }

    @Override
    public void setObject(int parameterIndex, Object theObject, int targetSqlType, int scale) throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
    }

    @Override
    public void setRef(int parameterIndex, Ref theRef) throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
    }

    @Override
    public void setShort(int parameterIndex, short theShort) throws SQLException {
        this.ensureCap(parameterIndex);
        this.setObj(parameterIndex, new Long(theShort));
    }

    @Override
    public void setString(int parameterIndex, String theString) {
        this.ensureCap(parameterIndex);
        this.setObj(parameterIndex, theString);
    }

    @Override
    public void setTime(int parameterIndex, Time theTime) throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
    }

    @Override
    public void setTime(int parameterIndex, Time theTime, Calendar cal) throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp theTimestamp) throws SQLException {
        this.ensureCap(parameterIndex);
        this.setObj(parameterIndex, theTimestamp);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp theTimestamp, Calendar cal) throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
    }

    @Override
    public void setURL(int parameterIndex, URL theURL) throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream theInputStream, int length) throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        return null;
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream inputStream) throws SQLException {
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream inputStream) throws SQLException {
        this.setBinaryStream(parameterIndex, inputStream, Integer.MAX_VALUE);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw new SQLException("SQLDroid does not allow input stream data greater than 2147483647");
        }
        this.setBinaryStream(parameterIndex, inputStream, (int)length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setNString(int parameterIndex, String theString) throws SQLException {
    }

    @Override
    public void setRowId(int parameterIndex, RowId theRowId) throws SQLException {
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }
}

