/*
 * Decompiled with CFR 0.152.
 */
package org.sqldroid;

import android.database.Cursor;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.sqldroid.DebugPrinter;
import org.sqldroid.SQLDroidConnection;
import org.sqldroid.SQLDroidResultSet;
import org.sqldroid.SQLiteDatabase;

public class SQLDroidStatement
implements Statement {
    private SQLiteDatabase db;
    private SQLDroidConnection sqldroidConnection;
    private SQLDroidResultSet rs = null;
    protected StringBuffer sqlBatch = new StringBuffer();
    private Integer maxRows = null;
    public int updateCount = -1;

    public SQLDroidStatement(SQLDroidConnection sqldroid) {
        this.sqldroidConnection = sqldroid;
        this.db = sqldroid.getDb();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.sqlBatch.append(sql);
    }

    @Override
    public void cancel() throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
    }

    @Override
    public void clearBatch() throws SQLException {
        this.sqlBatch = new StringBuffer();
    }

    @Override
    public void clearWarnings() throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
    }

    @Override
    public void close() throws SQLException {
        this.closeResultSet();
        this.sqldroidConnection = null;
        this.db = null;
    }

    public void closeResultSet() throws SQLException {
        if (this.rs != null) {
            if (!this.rs.isClosed()) {
                this.rs.close();
            }
            this.rs = null;
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.updateCount = -1;
        this.closeResultSet();
        boolean isSelect = sql.toUpperCase().matches("(?m)(?s)\\s*(SELECT|PRAGMA|EXPLAIN QUERY PLAN).*");
        if (this.rs != null && !this.rs.isClosed()) {
            this.rs.close();
        }
        if (isSelect) {
            String limitedSql = sql + (this.maxRows != null ? " LIMIT " + this.maxRows : "");
            Cursor c2 = this.db.rawQuery(limitedSql, new String[0]);
            this.rs = new SQLDroidResultSet(c2);
        } else {
            this.db.execSQL(sql);
            this.rs = null;
            this.updateCount = this.db.changedRowCount();
        }
        boolean resultSetAvailable = this.rs != null;
        return resultSetAvailable;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return false;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return false;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return false;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.updateCount = -1;
        int[] results = new int[]{-3};
        this.db.execSQL(this.sqlBatch.toString());
        results[0] = this.db.changedRowCount();
        this.updateCount = results[0];
        return results;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.closeResultSet();
        Cursor c2 = this.db.rawQuery(sql, null);
        this.rs = new SQLDroidResultSet(c2);
        return this.rs;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.closeResultSet();
        this.db.execSQL(sql);
        this.updateCount = this.db.changedRowCount();
        return this.updateCount;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return 0;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return 0;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return 0;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.sqldroidConnection;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return 0;
    }

    @Override
    public int getFetchSize() throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return 0;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.execute("SELECT last_insert_rowid()");
        return this.rs;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return 0;
    }

    @Override
    public int getMaxRows() throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return 0;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        if (current == 1) {
            this.closeResultSet();
        }
        return false;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return 0;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.rs;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return 0;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return 0;
    }

    @Override
    public int getResultSetType() throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return 0;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.updateCount != -1) {
            int tmp = this.updateCount;
            this.updateCount = -1;
            return tmp;
        }
        return this.updateCount;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return null;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Statement is closed.");
        }
        if (max < 0) {
            throw new SQLException("Max rows must be zero or positive. Got " + max);
        }
        this.maxRows = max == 0 ? null : Integer.valueOf(max);
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.sqldroidConnection == null;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        System.err.println(" ********************* not implemented @ " + DebugPrinter.getFileName() + " line " + DebugPrinter.getLineNumber());
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }
}

