/*
 * Decompiled with CFR 0.152.
 */
package org.sqldroid;

import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteException;
import java.lang.reflect.Method;
import org.sqldroid.Log;
import org.sqldroid.SQLDroidConnection;

public class SQLiteDatabase {
    protected android.database.sqlite.SQLiteDatabase sqliteDatabase;
    protected long timeout;
    protected long retryInterval;
    protected String dbQname;
    protected Method getChangedRowCount;

    protected boolean isLockedException(SQLiteException maybeLocked) {
        try {
            if (Class.forName("android.database.sqlite.SQLiteDatabaseLockedException", false, this.getClass().getClassLoader()).isAssignableFrom(maybeLocked.getClass())) {
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public SQLiteDatabase(String dbQname, long timeout, long retryInterval, int flags) throws java.sql.SQLException {
        this.dbQname = dbQname;
        this.timeout = timeout;
        this.retryInterval = retryInterval;
        long timeNow = System.currentTimeMillis();
        long delta = 0L;
        while (this.sqliteDatabase == null) {
            try {
                this.sqliteDatabase = android.database.sqlite.SQLiteDatabase.openDatabase((String)dbQname, null, (int)flags);
            }
            catch (SQLiteException e) {
                if (this.isLockedException(e)) {
                    try {
                        Thread.sleep(retryInterval);
                    }
                    catch (InterruptedException e1) {
                        // empty catch block
                    }
                    if ((delta = System.currentTimeMillis() - timeNow) < timeout) continue;
                    throw SQLDroidConnection.chainException((SQLException)((Object)e));
                }
                throw SQLDroidConnection.chainException((SQLException)((Object)e));
            }
        }
    }

    public Cursor rawQuery(String sql, String[] makeArgListQueryString) throws java.sql.SQLException {
        Log.v("SQLiteDatabase rawQuery: " + Thread.currentThread().getId() + " \"" + Thread.currentThread().getName() + "\" " + sql);
        long timeNow = System.currentTimeMillis();
        long delta = 0L;
        while (true) {
            try {
                Cursor cursor = this.sqliteDatabase.rawQuery(sql, makeArgListQueryString);
                Log.v("SQLiteDatabase rawQuery OK: " + Thread.currentThread().getId() + " \"" + Thread.currentThread().getName() + "\" " + sql);
                return cursor;
            }
            catch (SQLiteException e) {
                if (!this.isLockedException(e)) {
                    throw SQLDroidConnection.chainException((SQLException)((Object)e));
                }
                delta = System.currentTimeMillis() - timeNow;
                if (delta < this.timeout) continue;
                throw new java.sql.SQLException("Timeout Expired");
            }
            break;
        }
    }

    public void execSQL(String sql, Object[] makeArgListQueryObject) throws java.sql.SQLException {
        Log.v("SQLiteDatabase execSQL: " + Thread.currentThread().getId() + " \"" + Thread.currentThread().getName() + "\" " + sql);
        long timeNow = System.currentTimeMillis();
        long delta = 0L;
        while (true) {
            try {
                this.sqliteDatabase.execSQL(sql, makeArgListQueryObject);
                Log.v("SQLiteDatabase execSQL OK: " + Thread.currentThread().getId() + " \"" + Thread.currentThread().getName() + "\" " + sql);
                return;
            }
            catch (SQLiteException e) {
                if (!this.isLockedException(e)) {
                    throw SQLDroidConnection.chainException((SQLException)((Object)e));
                }
                delta = System.currentTimeMillis() - timeNow;
                if (delta < this.timeout) continue;
                throw new java.sql.SQLException("Timeout Expired");
            }
            break;
        }
    }

    public void execSQL(String sql) throws java.sql.SQLException {
        Log.v("SQLiteDatabase execSQL: " + Thread.currentThread().getId() + " \"" + Thread.currentThread().getName() + "\" " + sql);
        long timeNow = System.currentTimeMillis();
        long delta = 0L;
        while (true) {
            try {
                this.sqliteDatabase.execSQL(sql);
                Log.v("SQLiteDatabase execSQL OK: " + Thread.currentThread().getId() + " \"" + Thread.currentThread().getName() + "\" " + sql);
                return;
            }
            catch (SQLiteException e) {
                if (!this.isLockedException(e)) {
                    throw SQLDroidConnection.chainException((SQLException)((Object)e));
                }
                delta = System.currentTimeMillis() - timeNow;
                if (delta < this.timeout) continue;
                throw new java.sql.SQLException("Timeout Expired");
            }
            break;
        }
    }

    public android.database.sqlite.SQLiteDatabase getSqliteDatabase() {
        return this.sqliteDatabase;
    }

    public void execNoArgVoidMethod(Transaction transaction) throws java.sql.SQLException {
        long timeNow = System.currentTimeMillis();
        long delta = 0L;
        do {
            try {
                switch (transaction) {
                    case setTransactionSuccessful: {
                        this.sqliteDatabase.setTransactionSuccessful();
                        return;
                    }
                    case beginTransaction: {
                        this.sqliteDatabase.beginTransaction();
                        return;
                    }
                    case endTransaction: {
                        this.sqliteDatabase.endTransaction();
                        return;
                    }
                    case close: {
                        this.sqliteDatabase.close();
                        return;
                    }
                }
            }
            catch (SQLiteException e) {
                if (this.isLockedException(e)) {
                    delta = System.currentTimeMillis() - timeNow;
                    continue;
                }
                throw SQLDroidConnection.chainException((SQLException)((Object)e));
            }
        } while (delta < this.timeout);
        throw new java.sql.SQLException("Timeout Expired");
    }

    public void setTransactionSuccessful() throws java.sql.SQLException {
        this.execNoArgVoidMethod(Transaction.setTransactionSuccessful);
    }

    public void beginTransaction() throws java.sql.SQLException {
        this.execNoArgVoidMethod(Transaction.beginTransaction);
    }

    public void endTransaction() throws java.sql.SQLException {
        this.execNoArgVoidMethod(Transaction.endTransaction);
    }

    public void close() throws java.sql.SQLException {
        this.execNoArgVoidMethod(Transaction.close);
    }

    public int changedRowCount() {
        if (this.getChangedRowCount == null) {
            try {
                this.getChangedRowCount = this.sqliteDatabase.getClass().getMethod("changedRowCount", null);
            }
            catch (Exception any) {
                try {
                    this.getChangedRowCount = this.sqliteDatabase.getClass().getDeclaredMethod("lastChangeCount", null);
                    this.getChangedRowCount.setAccessible(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (this.getChangedRowCount != null) {
            try {
                return (Integer)this.getChangedRowCount.invoke((Object)this.sqliteDatabase, (Object[])null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 1;
    }

    protected static enum Transaction {
        setTransactionSuccessful,
        endTransaction,
        close,
        beginTransaction;

    }
}

