/*
 * Decompiled with CFR 0.152.
 */
package uni.hro.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import uni.hro.client.AquariumJPanel;
import uni.hro.model.World;
import uni.hro.nn.XMLFitnessRetriever;
import uni.hro.server.Settings;

public class Aquarium
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
    private JPanel contentPane;
    private JPanel movementPane;
    private AquariumJPanel aquariumJPanel;
    private JLabel xLabel = new JLabel();
    private boolean isOnPi = false;
    private Point initialClick;
    private int generation = 1;
    private Settings lastRunSettings;
    private XMLFitnessRetriever xMLFitnessRetriever = new XMLFitnessRetriever();

    public Aquarium(World world) {
        this.setTitle("Aquamarin");
        this.setType(Window.Type.UTILITY);
        this.setResizable(false);
        this.setUndecorated(true);
        if ("4.4.50-v7+".equals(System.getProperty("os.version"))) {
            gd.setFullScreenWindow(this);
            this.isOnPi = true;
        }
        this.setVisible(true);
        this.setDefaultCloseOperation(3);
        this.contentPane = new JPanel();
        this.movementPane = new JPanel();
        this.movementPane.setBackground(new Color(18, 120, 190));
        this.movementPane.setLayout(new BorderLayout());
        if (!this.isOnPi) {
            this.movementPane.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    Aquarium.this.initialClick = e.getPoint();
                    Aquarium.this.getComponentAt(Aquarium.this.initialClick);
                }
            });
            this.movementPane.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    int thisX = Aquarium.this.getLocation().x;
                    int thisY = Aquarium.this.getLocation().y;
                    int xMoved = thisX + e.getX() - (thisX + ((Aquarium)Aquarium.this).initialClick.x);
                    int yMoved = thisY + e.getY() - (thisY + ((Aquarium)Aquarium.this).initialClick.y);
                    int X = thisX + xMoved;
                    int Y = thisY + yMoved;
                    Aquarium.this.setLocation(X, Y);
                }
            });
        }
        this.contentPane.setBackground(new Color(18, 120, 190));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BorderLayout());
        this.setSize(world.getWidth(), world.getHeight());
        this.aquariumJPanel = new AquariumJPanel(world);
        this.contentPane.add((Component)this.aquariumJPanel, "Center");
        this.contentPane.add((Component)this.movementPane, "North");
        this.movementPane.add((Component)this.xLabel, "West");
        this.xLabel.setForeground(Color.WHITE);
        this.lastRunSettings = Settings.load();
        this.setGeneration(this.lastRunSettings.getNumGen());
        if (this.getGeneration() > 1) {
            XMLFitnessRetriever.retrieveFitness();
        }
        this.xLabel.setText("  Generation: " + this.getGeneration() + " Max: " + XMLFitnessRetriever.getMax() + " Avg: " + XMLFitnessRetriever.getAvg());
        this.aquariumJPanel.setCloseListener(new CloseWindowListener());
    }

    public int getDisplayHeight() {
        int height = gd.getDisplayMode().getHeight();
        return height;
    }

    public int getDisplayWidth() {
        int width = gd.getDisplayMode().getWidth();
        return width;
    }

    public GraphicsDevice getGD() {
        return gd;
    }

    public AquariumJPanel getaquariumJPanel() {
        return this.aquariumJPanel;
    }

    @Override
    public void repaint() {
        this.aquariumJPanel.repaint();
    }

    public int getGeneration() {
        return this.generation;
    }

    public void setGeneration(int generation) {
        this.generation = generation;
    }

    public void refreshLabel() {
        XMLFitnessRetriever.retrieveFitness();
        this.xLabel.setText("  Generation: " + this.getGeneration() + " Max: " + XMLFitnessRetriever.getMax() + " Avg: " + XMLFitnessRetriever.getAvg());
    }

    public void storeCurrentSettings() {
        this.lastRunSettings.setNumFish(this.lastRunSettings.getNumFish());
        this.lastRunSettings.setNumKraken(this.lastRunSettings.getNumKraken());
        this.lastRunSettings.setNumPlant(this.lastRunSettings.getNumPlant());
        this.lastRunSettings.setNumStone(this.lastRunSettings.getNumStone());
        this.lastRunSettings.setX(this.lastRunSettings.getX());
        this.lastRunSettings.setY(this.lastRunSettings.getY());
        this.lastRunSettings.setNumGen(this.getGeneration());
        this.lastRunSettings.store();
    }

    public void getLastFittnes() {
    }

    class CloseWindowListener
    implements ActionListener {
        CloseWindowListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Aquarium.this.storeCurrentSettings();
            System.exit(0);
        }
    }
}

