/*
 * Decompiled with CFR 0.152.
 */
package uni.hro.client;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import uni.hro.draw.DeadFishDrawer;
import uni.hro.draw.DeadKrakenDrawer;
import uni.hro.draw.FastForwardSymbolDrawer;
import uni.hro.draw.FishDrawer;
import uni.hro.draw.FoodDrawer;
import uni.hro.draw.GroundDrawer;
import uni.hro.draw.HitboxDrawer;
import uni.hro.draw.KrakenDrawer;
import uni.hro.draw.PlantDrawer;
import uni.hro.draw.StoneDrawer;
import uni.hro.draw.neuronalnetdrawer.NeuronalNetDrawerJFrame;
import uni.hro.model.Creature;
import uni.hro.model.Fish;
import uni.hro.model.Food;
import uni.hro.model.Kraken;
import uni.hro.model.Plant;
import uni.hro.model.Stone;
import uni.hro.model.World;
import uni.hro.model.WorldEntity;

public class AquariumJPanel
extends JPanel {
    Color backgroundColor = new Color(18, 120, 190);
    int displayWidth;
    int displayHeight;
    int frames = 0;
    long firstFrame;
    long currentFrame;
    int fps;
    HashSet<Stone> setOfStones = new HashSet();
    HashSet<Plant> setOfPlants = new HashSet();
    boolean showClock = false;
    DateTimeFormatter dtf = DateTimeFormatter.ofPattern("HH:mm:ss");
    LocalDateTime now = LocalDateTime.now();
    int jumpNumberOfGenerations = 0;
    int currentGeneration = 0;
    int bestFishFitness = 0;
    Fish bestFish = null;
    private JPopupMenu pop;
    private World world;
    private boolean fastforward;
    private JPanel panel;
    private boolean popShown = false;
    private JMenuItem closeWindowItem;

    public AquariumJPanel(World world) {
        this.displayWidth = world.getWidth();
        this.displayHeight = world.getHeight();
        this.world = world;
        this.pop = new JPopupMenu();
        this.menu();
        this.panel = this;
        this.prepareDrawing();
        this.repaint();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 1 && !AquariumJPanel.this.popShown) {
                    AquariumJPanel.this.pop.show(AquariumJPanel.this.panel, e.getX(), e.getY());
                    AquariumJPanel.this.popShown = true;
                } else {
                    AquariumJPanel.this.pop.setVisible(false);
                    AquariumJPanel.this.popShown = false;
                }
            }
        });
    }

    public HashSet<Plant> getSetOfPlants() {
        return this.setOfPlants;
    }

    public void setSetOfPlants(HashSet<Plant> setOfPlants) {
        this.setOfPlants = setOfPlants;
    }

    public void prepareDrawing() {
        int fishFitness;
        this.bestFishFitness = 0;
        for (WorldEntity s : new HashSet<WorldEntity>(this.world.getEntities())) {
            if (s instanceof Fish && ((Fish)s).getChromosome() != null && (fishFitness = ((Fish)s).getChromosome().getFitnessValue()) >= this.bestFishFitness) {
                this.bestFishFitness = fishFitness;
                this.bestFish = (Fish)s;
            }
            if (s instanceof Stone) {
                Stone newStone = (Stone)s;
                this.setOfStones.add(newStone);
            }
            if (!(s instanceof Plant)) continue;
            Plant plant = (Plant)s;
            this.setOfPlants.add(plant);
        }
        for (WorldEntity s : new HashSet<WorldEntity>(this.world.getEntities())) {
            if (!(s instanceof Fish) || ((Fish)s).getChromosome() == null || (fishFitness = ((Fish)s).getChromosome().getFitnessValue()) != this.bestFishFitness) continue;
            Color Goldfarbe = new Color(255, 230, 60);
            ((Fish)s).setColor(Goldfarbe);
            ((Fish)s).setCurrentColor(Goldfarbe);
        }
    }

    public void menu() {
        JSeparator sep = new JSeparator();
        JMenuItem informationItem = new JMenuItem("Show best Neuronal Net");
        JMenuItem stopJumping = new JMenuItem("Stop Jumping");
        JMenuItem jumpFive = new JMenuItem("Jump 5 Generations");
        JMenuItem jumpOneHundred = new JMenuItem("Jump 25 Generations");
        JMenuItem jumpFiveHundred = new JMenuItem("Jump 100 Generations");
        JMenuItem jumpUnlimited = new JMenuItem("Jump unlimited Generations");
        JSeparator sep2 = new JSeparator();
        JMenuItem showHideClock = new JMenuItem("show / hide Clock ");
        JSeparator sep3 = new JSeparator();
        this.closeWindowItem = new JMenuItem("End Simulation");
        this.pop.add(informationItem);
        this.pop.add(sep);
        this.pop.add(stopJumping);
        this.pop.add(jumpFive);
        this.pop.add(jumpOneHundred);
        this.pop.add(jumpFiveHundred);
        this.pop.add(jumpUnlimited);
        this.pop.add(sep2);
        this.pop.add(showHideClock);
        this.pop.add(sep3);
        this.pop.add(this.closeWindowItem);
        informationItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (AquariumJPanel.this.bestFishFitness <= 0) {
                    Creature lastFish = null;
                    for (WorldEntity object : new HashSet<WorldEntity>(AquariumJPanel.this.world.getEntities())) {
                        if (!(object instanceof Fish)) continue;
                        lastFish = (Fish)object;
                    }
                    NeuronalNetDrawerJFrame neuronalNetDrawerJFrame = new NeuronalNetDrawerJFrame();
                    neuronalNetDrawerJFrame.drawChromosome(lastFish.getChromosome());
                } else {
                    NeuronalNetDrawerJFrame neuronalNetDrawerJFrame = new NeuronalNetDrawerJFrame();
                    neuronalNetDrawerJFrame.drawChromosome(AquariumJPanel.this.bestFish.getChromosome());
                }
            }
        });
        showHideClock.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AquariumJPanel.this.showClock = !AquariumJPanel.this.showClock;
                AquariumJPanel.this.pop.setVisible(false);
            }
        });
        stopJumping.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AquariumJPanel.this.fastforward = false;
                AquariumJPanel.this.setJumpNumberOfGenerations(AquariumJPanel.this.currentGeneration - 1);
                AquariumJPanel.this.pop.setVisible(false);
                AquariumJPanel.this.popShown = false;
            }
        });
        jumpFive.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AquariumJPanel.this.fastforward = true;
                AquariumJPanel.this.setJumpNumberOfGenerations(AquariumJPanel.this.currentGeneration + 5);
                AquariumJPanel.this.pop.setVisible(false);
                AquariumJPanel.this.popShown = false;
            }
        });
        jumpOneHundred.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AquariumJPanel.this.fastforward = true;
                AquariumJPanel.this.setJumpNumberOfGenerations(AquariumJPanel.this.currentGeneration + 25);
                AquariumJPanel.this.pop.setVisible(false);
                AquariumJPanel.this.popShown = false;
            }
        });
        jumpFiveHundred.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AquariumJPanel.this.fastforward = true;
                AquariumJPanel.this.setJumpNumberOfGenerations(AquariumJPanel.this.currentGeneration + 100);
                AquariumJPanel.this.pop.setVisible(false);
                AquariumJPanel.this.popShown = false;
            }
        });
        jumpUnlimited.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AquariumJPanel.this.fastforward = true;
                AquariumJPanel.this.setJumpNumberOfGenerations(999999999);
                AquariumJPanel.this.pop.setVisible(false);
                AquariumJPanel.this.popShown = false;
            }
        });
    }

    public void setCloseListener(ActionListener l) {
        this.closeWindowItem.addActionListener(l);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.setBackground(this.backgroundColor);
        ++this.frames;
        this.currentFrame = System.currentTimeMillis();
        if (this.currentFrame > this.firstFrame + 1000L) {
            this.firstFrame = this.currentFrame;
            this.fps = this.frames;
            this.frames = 0;
        }
        String fpss = "FPS: " + this.fps;
        g.drawString(fpss, 0, 10);
        if (this.showClock) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.translate(this.displayWidth - 200, 45);
            g.setFont(new Font("Dialog", 1, 40));
            g.setColor(new Color(236, 226, 254));
            LocalDateTime now = LocalDateTime.now();
            g.drawString(this.dtf.format(now), 0, 10);
            g.translate(-(this.displayWidth - 200), -45);
        }
        GroundDrawer.draw(g, this.displayWidth, this.displayHeight, new Color(232, 235, 224), 1.0, 1.0);
        try {
            for (WorldEntity s : new HashSet<WorldEntity>(this.world.getEntities())) {
                if (s instanceof Fish) {
                    Fish fish = (Fish)s;
                    if (fish.isAlive()) {
                        FishDrawer.draw(g, fish);
                        if (!this.showClock) {
                            HitboxDrawer.draw(g, fish);
                        }
                    } else {
                        DeadFishDrawer.draw(g, fish);
                    }
                }
                if (s instanceof Kraken) {
                    Kraken kraken = (Kraken)s;
                    if (kraken.isAlive()) {
                        KrakenDrawer.draw(g, kraken);
                        if (!this.showClock) {
                            HitboxDrawer.draw(g, kraken);
                        }
                    } else {
                        DeadKrakenDrawer.draw(g, kraken);
                    }
                }
                if (!(s instanceof Food)) continue;
                Food food = (Food)s;
                FoodDrawer.draw(g, food);
            }
            for (Stone stone : this.setOfStones) {
                StoneDrawer.draw(g, stone);
            }
            for (Plant plant : this.setOfPlants) {
                PlantDrawer.draw(g, plant);
            }
        }
        catch (ConcurrentModificationException e) {
            System.err.println("AquariumJPanel.paintComponent().drawing had concurrency issues. no problem so far.");
        }
        if (this.fastforward) {
            FastForwardSymbolDrawer.draw(g, this.displayWidth, this.displayHeight);
            this.fastforward = false;
        }
    }

    public World getWorld() {
        return this.world;
    }

    public int getJumpNumberOfGenerations() {
        return this.jumpNumberOfGenerations;
    }

    public void setJumpNumberOfGenerations(int jumpNumber) {
        this.jumpNumberOfGenerations = jumpNumber;
    }

    public boolean isFastforward() {
        return this.fastforward;
    }

    public void setFastforward(boolean fastforward) {
        this.fastforward = fastforward;
    }

    public int getCurrentGeneration() {
        return this.currentGeneration;
    }

    public void setCurrentGeneration(int currentGeneration) {
        this.currentGeneration = currentGeneration;
    }
}

