/*
 * Decompiled with CFR 0.152.
 */
package uni.hro.client;

import de.mein.auth.tools.N;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import uni.hro.networking.service.AquaClientService;

public class ClientGui
extends JFrame {
    private static GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
    private final AquaClientService clientSevice;
    private JPanel contentPane;
    private JTextField serverAddressField;
    private JButton button1;
    private JButton button2;
    private JButton button3;
    private JButton button4;
    private JButton button5;
    private JButton button6;
    private JButton button7;
    private JButton button8;
    private JButton button9;
    private JButton button0;
    private JButton buttonDot;
    private JButton buttonDel;
    private JButton connectButton;
    private JButton exitButton;
    private JButton connectLButton;

    public ClientGui(final AquaClientService clientService) {
        this.clientSevice = clientService;
        this.setMinimumSize(new Dimension(319, 479));
        this.setTitle("Aquarium Client");
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 450, 228);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BorderLayout(0, 0));
        this.serverAddressField = new JTextField();
        this.serverAddressField.setFont(new Font("Tahoma", 0, 18));
        this.contentPane.add((Component)this.serverAddressField, "North");
        this.serverAddressField.setColumns(10);
        JPanel centerPanel = new JPanel();
        this.contentPane.add((Component)centerPanel, "Center");
        this.button1 = new JButton("1");
        this.button1.setPreferredSize(new Dimension(120, 90));
        this.button1.setMinimumSize(new Dimension(90, 90));
        centerPanel.add(this.button1);
        this.button2 = new JButton("2");
        this.button2.setPreferredSize(new Dimension(120, 90));
        this.button2.setMinimumSize(new Dimension(90, 90));
        centerPanel.add(this.button2);
        this.button3 = new JButton("3");
        this.button3.setPreferredSize(new Dimension(120, 90));
        this.button3.setMinimumSize(new Dimension(90, 90));
        centerPanel.add(this.button3);
        this.button4 = new JButton("4");
        this.button4.setPreferredSize(new Dimension(120, 90));
        this.button4.setMinimumSize(new Dimension(90, 90));
        centerPanel.add(this.button4);
        this.button5 = new JButton("5");
        this.button5.setPreferredSize(new Dimension(120, 90));
        this.button5.setMinimumSize(new Dimension(90, 90));
        centerPanel.add(this.button5);
        this.button6 = new JButton("6");
        this.button6.setPreferredSize(new Dimension(120, 90));
        this.button6.setMinimumSize(new Dimension(90, 90));
        centerPanel.add(this.button6);
        this.button7 = new JButton("7");
        this.button7.setPreferredSize(new Dimension(120, 90));
        this.button7.setMinimumSize(new Dimension(90, 90));
        centerPanel.add(this.button7);
        this.button8 = new JButton("8");
        this.button8.setPreferredSize(new Dimension(120, 90));
        this.button8.setMinimumSize(new Dimension(90, 90));
        centerPanel.add(this.button8);
        this.button9 = new JButton("9");
        this.button9.setPreferredSize(new Dimension(120, 90));
        this.button9.setMinimumSize(new Dimension(90, 90));
        centerPanel.add(this.button9);
        this.buttonDot = new JButton(".");
        this.buttonDot.setPreferredSize(new Dimension(120, 90));
        this.buttonDot.setMinimumSize(new Dimension(90, 90));
        centerPanel.add(this.buttonDot);
        this.button0 = new JButton("0");
        this.button0.setPreferredSize(new Dimension(120, 90));
        this.button0.setMinimumSize(new Dimension(90, 90));
        centerPanel.add(this.button0);
        this.buttonDel = new JButton("DEL");
        this.buttonDel.setPreferredSize(new Dimension(120, 90));
        centerPanel.add(this.buttonDel);
        JPanel southPanel = new JPanel();
        this.contentPane.add((Component)southPanel, "South");
        southPanel.setLayout(new FlowLayout(1, 5, 5));
        this.exitButton = new JButton("Exit");
        southPanel.add(this.exitButton);
        this.connectButton = new JButton("Connect");
        southPanel.add(this.connectButton);
        this.connectLButton = new JButton("Connect localhost");
        southPanel.add(this.connectLButton);
        if ("4.4.50-v7+".equals(System.getProperty("os.version"))) {
            this.setResizable(false);
            this.setUndecorated(true);
            gd.setFullScreenWindow(this);
        } else {
            this.setResizable(true);
            this.setUndecorated(false);
        }
        this.setVisible(true);
        this.button1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                ClientGui.this.serverAddressField.setText(String.valueOf(ClientGui.this.serverAddressField.getText()) + "1");
            }
        });
        this.button2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                ClientGui.this.serverAddressField.setText(String.valueOf(ClientGui.this.serverAddressField.getText()) + "2");
            }
        });
        this.button3.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                ClientGui.this.serverAddressField.setText(String.valueOf(ClientGui.this.serverAddressField.getText()) + "3");
            }
        });
        this.button4.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                ClientGui.this.serverAddressField.setText(String.valueOf(ClientGui.this.serverAddressField.getText()) + "4");
            }
        });
        this.button5.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                ClientGui.this.serverAddressField.setText(String.valueOf(ClientGui.this.serverAddressField.getText()) + "5");
            }
        });
        this.button6.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                ClientGui.this.serverAddressField.setText(String.valueOf(ClientGui.this.serverAddressField.getText()) + "6");
            }
        });
        this.button7.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                ClientGui.this.serverAddressField.setText(String.valueOf(ClientGui.this.serverAddressField.getText()) + "7");
            }
        });
        this.button8.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                ClientGui.this.serverAddressField.setText(String.valueOf(ClientGui.this.serverAddressField.getText()) + "8");
            }
        });
        this.button9.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                ClientGui.this.serverAddressField.setText(String.valueOf(ClientGui.this.serverAddressField.getText()) + "9");
            }
        });
        this.button0.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                ClientGui.this.serverAddressField.setText(String.valueOf(ClientGui.this.serverAddressField.getText()) + "0");
            }
        });
        this.buttonDot.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                ClientGui.this.serverAddressField.setText(String.valueOf(ClientGui.this.serverAddressField.getText()) + ".");
            }
        });
        this.buttonDel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                ClientGui.this.serverAddressField.setText(ClientGui.this.serverAddressField.getText().substring(0, ClientGui.this.serverAddressField.getText().length() - 1));
            }
        });
        this.exitButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                System.exit(0);
            }
        });
        this.connectButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                String ipAddress = ClientGui.this.serverAddressField.getText();
                ClientGui.this.serverAddressField.setText("Trying to connect to a server on " + ipAddress);
                ClientGui.this.deactivateButtons();
                N.r(() -> clientService.regAsClient(ipAddress, 8888, 8889).done(result2 -> {
                    System.out.println("ClientGui.mouseClicked.Verbunden!");
                    ClientGui.this.serverAddressField.setText("Connected, waiting for the server to start ...");
                    ClientGui.this.serverAddressField.setBackground(new Color(0, 255, 0));
                }).fail(result2 -> {
                    System.out.println("ClientGui.mouseClicked.Nicht verbinden! Ging was Schief: " + result2.toString());
                    ClientGui.this.activateButtons();
                    ClientGui.this.serverAddressField.setText("Could not create a connection to the server on " + ipAddress);
                    ClientGui.this.serverAddressField.setBackground(new Color(255, 0, 0));
                }));
            }
        });
        this.connectLButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                N.r(() -> clientService.regAsClient("localhost", 8888, 8889).done(result2 -> {
                    System.out.println("ClientGui.mouseClicked.Verbunden!");
                    ClientGui.this.serverAddressField.setText("Connected, waiting for the server to start ...");
                    ClientGui.this.serverAddressField.setBackground(new Color(0, 255, 0));
                }).fail(result2 -> {
                    System.out.println("ClientGui.mouseClicked.Nicht verbinden! Ging was Schief: " + result2.toString());
                    ClientGui.this.activateButtons();
                    ClientGui.this.serverAddressField.setText("Could not create a connection to the server on localhost");
                    ClientGui.this.serverAddressField.setBackground(new Color(255, 0, 0));
                }));
            }
        });
    }

    public String getServerAddressFieldText() {
        return this.serverAddressField.getText();
    }

    public void setServerAddressFieldText(String newText) {
        this.serverAddressField.setText(newText);
    }

    public JTextField getServerAddressField() {
        return this.serverAddressField;
    }

    public void deactivateButtons() {
        this.button1.setEnabled(false);
        this.button2.setEnabled(false);
        this.button3.setEnabled(false);
        this.button4.setEnabled(false);
        this.button5.setEnabled(false);
        this.button6.setEnabled(false);
        this.button7.setEnabled(false);
        this.button8.setEnabled(false);
        this.button9.setEnabled(false);
        this.button0.setEnabled(false);
        this.buttonDot.setEnabled(false);
        this.buttonDel.setEnabled(false);
        this.exitButton.setEnabled(false);
        this.connectButton.setEnabled(false);
        this.connectLButton.setEnabled(false);
    }

    public void activateButtons() {
        this.button1.setEnabled(true);
        this.button2.setEnabled(true);
        this.button3.setEnabled(true);
        this.button4.setEnabled(true);
        this.button5.setEnabled(true);
        this.button6.setEnabled(true);
        this.button7.setEnabled(true);
        this.button8.setEnabled(true);
        this.button9.setEnabled(true);
        this.button0.setEnabled(true);
        this.buttonDot.setEnabled(true);
        this.buttonDel.setEnabled(true);
        this.exitButton.setEnabled(true);
        this.connectButton.setEnabled(true);
        this.connectLButton.setEnabled(true);
    }

    public void setConnectListener(ActionListener l) {
        this.connectButton.addActionListener(l);
    }
}

