/*
 * Decompiled with CFR 0.152.
 */
package uni.hro.draw;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.Random;

public class GroundDrawer {
    static int[] xPoints2;
    static int[] yPoints2;

    public static void draw(Graphics g, int screenResolutionX, int screenResolutionY, Color color, double sizefactorX, double sizefactorY) {
        Graphics2D g2 = (Graphics2D)g;
        g2.translate(0, screenResolutionY);
        AffineTransform atOriginal = g2.getTransform();
        AffineTransform at = new AffineTransform();
        at.setToScale(sizefactorX, sizefactorY);
        if (sizefactorX < 0.0) {
            g2.translate(-100.0 * sizefactorX, 0.0);
        }
        g2.transform(at);
        if (xPoints2 == null) {
            xPoints2 = GroundDrawer.createRandomizedGeometrieValuesX(screenResolutionX);
            yPoints2 = GroundDrawer.createRandomizedGeometrieValuesY(screenResolutionX);
        }
        int nPoints2 = xPoints2.length;
        g2.setColor(color);
        g2.fillPolygon(xPoints2, yPoints2, nPoints2);
        g2.setColor(Color.BLACK);
        g2.drawPolygon(xPoints2, yPoints2, nPoints2);
        g2.translate(0, -screenResolutionY);
    }

    public static int[] createRandomizedGeometrieValuesX(int screenResolutionX) {
        int stepSize = 20;
        int lastXpoint = screenResolutionX / stepSize + 3;
        int[] xPoints = new int[lastXpoint];
        int currentGroundlength = 0;
        int iterator = 2;
        xPoints[0] = currentGroundlength;
        xPoints[1] = currentGroundlength;
        while (iterator < xPoints.length) {
            xPoints[iterator] = currentGroundlength += stepSize;
            ++iterator;
        }
        xPoints[lastXpoint - 2] = currentGroundlength;
        xPoints[lastXpoint - 1] = currentGroundlength;
        return xPoints;
    }

    public static int[] createRandomizedGeometrieValuesY(int screenResolutionX) {
        int stepSize = 20;
        int lastYpoint = screenResolutionX / stepSize + 3;
        int[] yPoints = new int[lastYpoint];
        int iterator = 2;
        yPoints[0] = 0;
        yPoints[1] = -50;
        while (iterator < yPoints.length) {
            yPoints[iterator] = -50 + GroundDrawer.generateRandom(5, 10);
            ++iterator;
        }
        yPoints[lastYpoint - 2] = -50;
        yPoints[lastYpoint - 1] = 0;
        return yPoints;
    }

    public static int generateRandom(int min, int max) {
        Random rn = new Random();
        int randomvalue = rn.nextInt(max - min + 1) + min;
        return randomvalue;
    }
}

