/*
 * Decompiled with CFR 0.152.
 */
package uni.hro.draw;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Map;
import uni.hro.model.Creature;
import uni.hro.model.HitBox;
import uni.hro.model.Point;
import uni.hro.model.WorldEntity;

public class HitboxDrawer {
    public static void draw(Graphics graphics, WorldEntity worldEntity) {
        Graphics2D g2 = (Graphics2D)graphics;
        float x = worldEntity.getX();
        float y = worldEntity.getY();
        float halfWidth = worldEntity.getHalfWidth();
        float halfHeight = worldEntity.getHalfHeight();
        int xx = (int)(x - halfWidth);
        int yy = (int)(y - halfHeight);
        int ww = (int)(2.0f * halfWidth);
        int hh = (int)(2.0f * halfHeight);
        g2.drawRect(xx, yy, ww, hh);
        if (worldEntity instanceof Creature) {
            Creature creature = (Creature)worldEntity;
            Map<HitBox, Point<Integer>> neurons = creature.getHitboxes();
            g2.setColor(Color.gray);
            for (HitBox neuron : neurons.keySet()) {
                Point<Integer> nPoint = neurons.get(neuron);
                float direction = creature.looksLeft() ? -1.0f : 1.0f;
                float fff = y + y * 2.0f * halfHeight - halfHeight;
                int neuronTopY = neuron.getTopY();
                int neuronLeftX = neuron.getLeftX();
                if (neuron.getPerceivedEntities().size() > 0) {
                    g2.setColor(Color.RED);
                } else {
                    g2.setColor(Color.gray);
                }
                g2.drawRect(neuronLeftX, neuronTopY, 24, 24);
            }
        }
    }
}

