/*
 * Decompiled with CFR 0.152.
 */
package uni.hro.draw;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.util.Random;
import uni.hro.model.Plant;

public class PlantDrawer {
    public static void draw(Graphics g, Plant plant) {
        Graphics2D g2 = (Graphics2D)g;
        int positionX = (int)plant.getX();
        int positionY = (int)plant.getY();
        int numberOfSegments = plant.getNumberofSegments();
        int[] xPoints = plant.getxLeafGeometriePoints();
        int[] yPoints = plant.getyLeafGeometriePoints();
        double sizefactorX = 0.3;
        double sizefactorY = 0.3;
        double plantAngle = plant.getCurrentAngle();
        Color color = plant.getCurrentColor();
        g2.translate(positionX, positionY);
        AffineTransform atOriginal = g2.getTransform();
        AffineTransform at = new AffineTransform();
        at.setToScale(sizefactorX, sizefactorY);
        if (sizefactorX < 0.0) {
            g2.translate(-100.0 * sizefactorX, 0.0);
        }
        g2.transform(at);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        PlantDrawer.drawABranch(g2, numberOfSegments, xPoints, yPoints, plantAngle, color);
        g2.setTransform(atOriginal);
        g2.translate(-positionX, -positionY);
    }

    private static void drawABranch(Graphics2D g2, int numberofSegments, int[] xPoints, int[] yPoints, double plantAngle, Color color) {
        int endOfBranchX = 0;
        int endofBranchY = -100;
        int iterator = 0;
        while (iterator <= numberofSegments) {
            PlantDrawer.drawABranchPart(g2, plantAngle, endOfBranchX, endofBranchY, xPoints, yPoints, color);
            ++iterator;
        }
        AffineTransform at = new AffineTransform();
        at.rotate(45.0);
        g2.transform(at);
        PlantDrawer.drawALeaf(g2, true, 0, 0, xPoints, yPoints, color);
        AffineTransform at2 = new AffineTransform();
        at.rotate(plantAngle);
        g2.transform(at2);
    }

    private static void drawABranchPart(Graphics2D g2, double plantAngle, int endOfBranchX, int endofBranchY, int[] xPoints, int[] yPoints, Color color) {
        AffineTransform at = new AffineTransform();
        at.rotate(plantAngle);
        g2.transform(at);
        g2.setColor(color);
        g2.fillRect(0, endofBranchY, endOfBranchX + 5, -endofBranchY);
        g2.setColor(Color.BLACK);
        g2.drawRect(0, endofBranchY, endOfBranchX + 5, -endofBranchY);
        PlantDrawer.drawALeaf(g2, true, 0, 0, xPoints, yPoints, color);
        PlantDrawer.drawALeaf(g2, true, 0, -50, xPoints, yPoints, color);
        g2.translate(0, 50);
        PlantDrawer.drawALeaf(g2, false, 0, 0, xPoints, yPoints, color);
        PlantDrawer.drawALeaf(g2, false, 0, -50, xPoints, yPoints, color);
        g2.translate(0, -50);
    }

    private static void drawALeaf(Graphics2D g2, boolean left, int TranslatePositionX, int TranslatePositionY, int[] xPoints, int[] yPoints, Color color) {
        if (left) {
            g2.translate(TranslatePositionX, TranslatePositionY);
            AffineTransform at = new AffineTransform();
            at.rotate(-45.0);
            g2.transform(at);
            int[] xPoints2 = xPoints;
            int[] yPoints2 = yPoints;
            int nPoints2 = xPoints2.length;
            g2.setColor(color);
            g2.fillPolygon(xPoints2, yPoints2, nPoints2);
            g2.setColor(Color.BLACK);
            g2.drawPolygon(xPoints2, yPoints2, nPoints2);
            AffineTransform at2 = new AffineTransform();
            at2.rotate(45.0);
            g2.transform(at2);
        } else {
            g2.translate(TranslatePositionX, TranslatePositionY);
            AffineTransform at = new AffineTransform();
            at.rotate(45.0);
            g2.transform(at);
            int[] xPoints2 = xPoints;
            int[] yPoints2 = yPoints;
            int nPoints2 = xPoints2.length;
            g2.setColor(color);
            g2.fillPolygon(xPoints2, yPoints2, nPoints2);
            g2.setColor(Color.BLACK);
            g2.drawPolygon(xPoints2, yPoints2, nPoints2);
            AffineTransform at2 = new AffineTransform();
            at2.rotate(-45.0);
            g2.transform(at2);
        }
    }

    public static int[] createRandomizedGeometrieValuesX() {
        int[] nArray = new int[11];
        nArray[1] = -10;
        nArray[2] = -20;
        nArray[3] = -30;
        nArray[4] = -10;
        nArray[6] = 10;
        nArray[7] = 30;
        nArray[8] = 20;
        nArray[9] = 10;
        int[] xPoints = nArray;
        return xPoints;
    }

    public static int[] createRandomizedGeometrieValuesY() {
        int a2 = -20 + PlantDrawer.generateRandom(-20, 20);
        int b2 = -40 + PlantDrawer.generateRandom(-20, 20);
        int c2 = -60 + PlantDrawer.generateRandom(-20, 20);
        int d = -80 + PlantDrawer.generateRandom(-30, 20);
        int e = -100 + PlantDrawer.generateRandom(-40, 20);
        int[] nArray = new int[11];
        nArray[1] = a2;
        nArray[2] = b2;
        nArray[3] = c2;
        nArray[4] = d;
        nArray[5] = e;
        nArray[6] = d;
        nArray[7] = c2;
        nArray[8] = b2;
        nArray[9] = a2;
        int[] yPoints = nArray;
        return yPoints;
    }

    public static int generateRandom(int min, int max) {
        Random rn = new Random();
        int randomvalue = rn.nextInt(max - min + 1) + min;
        return randomvalue;
    }
}

