/*
 * Decompiled with CFR 0.152.
 */
package uni.hro.draw;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.util.Random;
import uni.hro.model.Stone;

public class StoneDrawer {
    public static void draw(Graphics g, Stone stone) {
        Graphics2D g2 = (Graphics2D)g;
        int positionX = (int)stone.getX() - 40;
        int positionY = (int)stone.getY() + 23;
        int[] xPoints = stone.getxGeometriePoints();
        int[] yPoints = stone.getyGeometriePoints();
        double sizefactorX = 0.8;
        double sizefactorY = 0.53;
        Color color = stone.getCurrentColor();
        g2.translate(positionX, positionY);
        AffineTransform atOriginal = g2.getTransform();
        AffineTransform at = new AffineTransform();
        at.setToScale(sizefactorX, sizefactorY);
        if (sizefactorX < 0.0) {
            g2.translate(-100.0 * sizefactorX, 0.0);
        }
        g2.transform(at);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int[] xPoints2 = xPoints;
        int[] yPoints2 = yPoints;
        int nPoints2 = xPoints.length;
        g2.setColor(color);
        g2.fillPolygon(xPoints2, yPoints2, nPoints2);
        g2.setColor(Color.BLACK);
        g2.drawPolygon(xPoints2, yPoints2, nPoints2);
        g2.setTransform(atOriginal);
        g2.translate(-positionX, -positionY);
    }

    public int[] createRandomizedGeometrieValuesX() {
        int[] nArray = new int[11];
        nArray[1] = -12;
        nArray[3] = 10;
        nArray[4] = 40;
        nArray[5] = 50;
        nArray[6] = 60;
        nArray[7] = 70;
        nArray[8] = 100;
        nArray[9] = 112;
        nArray[10] = 100;
        int[] xPoints = nArray;
        return xPoints;
    }

    public int[] createRandomizedGeometrieValuesY() {
        int[] nArray = new int[11];
        nArray[1] = -20 + StoneDrawer.generateRandom(-20, 20);
        nArray[2] = -40 + StoneDrawer.generateRandom(-20, 20);
        nArray[3] = -60 + StoneDrawer.generateRandom(-20, 20);
        nArray[4] = -80 + StoneDrawer.generateRandom(-5, 2);
        nArray[5] = -100 + StoneDrawer.generateRandom(0, 20);
        nArray[6] = -80 + StoneDrawer.generateRandom(-5, 20);
        nArray[7] = -60 + StoneDrawer.generateRandom(-20, 20);
        nArray[8] = -40 + StoneDrawer.generateRandom(-20, 20);
        nArray[9] = -20 + StoneDrawer.generateRandom(-20, 20);
        int[] yPoints = nArray;
        return yPoints;
    }

    public static int generateRandom(int min, int max) {
        Random rn = new Random();
        int randomvalue = rn.nextInt(max - min + 1) + min;
        return randomvalue;
    }
}

