/*
 * Decompiled with CFR 0.152.
 */
package uni.hro.draw.neuronalnetdrawer;

import com.anji.neat.ConnectionAllele;
import com.anji.neat.NeuronAllele;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.SortedSet;
import javax.swing.JPanel;
import org.jgap.Chromosome;
import uni.hro.draw.neuronalnetdrawer.Connection;
import uni.hro.draw.neuronalnetdrawer.Hiddenneuron;
import uni.hro.draw.neuronalnetdrawer.Inputneuron;
import uni.hro.draw.neuronalnetdrawer.Neuron;
import uni.hro.draw.neuronalnetdrawer.Outputneuron;

public class NeuronalNetDrawerJPanel
extends JPanel {
    Chromosome chromosome;
    protected boolean mousePressed = false;
    private SortedSet alleles;
    ArrayList<ArrayList<Neuron>> neurons = new ArrayList();
    ArrayList<Neuron> inputneurons = new ArrayList();
    ArrayList<Neuron> outputneurons = new ArrayList();
    ArrayList<Neuron> hiddenneurons = new ArrayList();
    ArrayList<Connection> connections = new ArrayList();
    Color highlightColor = new Color(63, 72, 204);
    Color inColor = new Color(63, 204, 72);
    Color outColor = new Color(204, 72, 63);
    Color lowightColor = new Color(200, 200, 200);

    public NeuronalNetDrawerJPanel(Chromosome chromosome) {
        this.chromosome = chromosome;
        this.alleles = chromosome.getAlleles();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    int xOfMouseClick = e.getX();
                    int yOfMouseClick = e.getY();
                    NeuronalNetDrawerJPanel.this.highlightTheClickedObject(xOfMouseClick, yOfMouseClick);
                    NeuronalNetDrawerJPanel.this.repaint();
                }
            }
        });
        this.prepareDrawing();
        this.repaint();
    }

    public void prepareDrawing() {
        int inputneuronCounter = 0;
        int outputneuronCounter = 1;
        int hiddenneuronCounter = 0;
        int distanceBetweenNeurons = 40;
        for (Object allele : this.alleles) {
            long id;
            if (allele instanceof NeuronAllele) {
                if (inputneuronCounter < 152) {
                    id = ((NeuronAllele)allele).getInnovationId();
                    Inputneuron inputneuron = new Inputneuron(id, 100, 100 + inputneuronCounter * distanceBetweenNeurons);
                    this.inputneurons.add(inputneuron);
                    ++inputneuronCounter;
                } else if (outputneuronCounter < 5) {
                    id = ((NeuronAllele)allele).getInnovationId();
                    Outputneuron outputneuron = new Outputneuron(id, 900, 400 + outputneuronCounter * distanceBetweenNeurons);
                    this.outputneurons.add(outputneuron);
                    ++outputneuronCounter;
                } else {
                    id = ((NeuronAllele)allele).getInnovationId();
                    Hiddenneuron hiddenneuron = new Hiddenneuron(id, 450, 100 + hiddenneuronCounter * distanceBetweenNeurons);
                    this.hiddenneurons.add(hiddenneuron);
                    ++hiddenneuronCounter;
                }
            }
            if (!(allele instanceof ConnectionAllele)) continue;
            ConnectionAllele connectionAllele = (ConnectionAllele)allele;
            id = connectionAllele.getInnovationId();
            long sourceNeuronId = connectionAllele.getSrcNeuronId();
            long destinationNeuronId = connectionAllele.getDestNeuronId();
            double weight = connectionAllele.getWeight();
            Connection connection = new Connection(id, sourceNeuronId, destinationNeuronId, weight);
            this.connections.add(connection);
        }
        this.connectionsfindNeurons();
        this.checkBestDrawingPosition();
        this.neurons.add(this.inputneurons);
        this.neurons.add(this.outputneurons);
        this.neurons.add(this.hiddenneurons);
    }

    private void checkBestDrawingPosition() {
        int xOfEndneuron;
        int xOfStartneuron;
        int highestHiddenneuronCenterX = 700;
        int distanceBetweenNeurons = 100;
        for (Neuron neuron : this.hiddenneurons) {
            for (Connection con : neuron.getConnList()) {
                if (neuron.getId() != con.getEndneuronId()) continue;
                xOfStartneuron = con.getStartNeuron().getCenterX();
                xOfEndneuron = con.getEndNeuron().getCenterX();
                if (xOfEndneuron - xOfStartneuron >= distanceBetweenNeurons) continue;
                neuron.setCenterX(xOfEndneuron + distanceBetweenNeurons);
                neuron.setX(xOfEndneuron + distanceBetweenNeurons - neuron.getSize() / 2);
                if (highestHiddenneuronCenterX >= xOfEndneuron + distanceBetweenNeurons) continue;
                highestHiddenneuronCenterX = xOfEndneuron + distanceBetweenNeurons;
            }
        }
        for (Neuron neuron : this.outputneurons) {
            neuron.setCenterX(highestHiddenneuronCenterX + 200);
            neuron.setX(highestHiddenneuronCenterX + 200 - neuron.getSize() / 2);
            for (Connection con : neuron.getConnList()) {
                if (neuron.getId() != con.getEndneuronId()) continue;
                xOfStartneuron = con.getStartNeuron().getCenterX();
                xOfEndneuron = con.getEndNeuron().getCenterX();
                if (xOfEndneuron - xOfStartneuron >= distanceBetweenNeurons) continue;
                neuron.setCenterX(xOfEndneuron + distanceBetweenNeurons);
                neuron.setX(xOfEndneuron + distanceBetweenNeurons - neuron.getSize() / 2);
            }
        }
    }

    private void highlightTheClickedObject(int xOfMouseClick, int yOfMouseClick) {
        int objectSize = 20;
        int counter = 0;
        boolean nothingWasClicked = true;
        for (ArrayList<Neuron> neuronlist : this.neurons) {
            for (Neuron neuron : neuronlist) {
                neuron.setColor(this.lowightColor);
                neuron.setHighlighted(false);
                if (neuron.getCenterX() - objectSize / 2 <= xOfMouseClick && neuron.getCenterX() + objectSize / 2 >= xOfMouseClick && neuron.getCenterY() - objectSize / 2 <= yOfMouseClick && neuron.getCenterY() + objectSize / 2 >= yOfMouseClick) {
                    neuron.setColor(this.highlightColor);
                    nothingWasClicked = false;
                    neuron.setHighlighted(true);
                    this.highlightAllConnectedElements(neuron);
                }
                ++counter;
            }
        }
        for (ArrayList<Neuron> neuronlist : this.neurons) {
            for (Neuron neuron : neuronlist) {
                if (!nothingWasClicked) continue;
                neuron.setColor(Color.black);
                for (Connection con : neuron.getConnList()) {
                    con.setHighlighted(false);
                }
            }
            for (Connection con : this.connections) {
                if (!nothingWasClicked) continue;
                con.setColor(Color.black);
            }
        }
    }

    private void highlightAllConnectedElements(Neuron neuron) {
        for (Connection con : this.connections) {
            con.setColor(this.lowightColor);
            con.setHighlighted(false);
        }
        for (Connection con : neuron.getConnList()) {
            if (neuron == con.getEndNeuron()) {
                con.setColor(this.inColor);
                con.setHighlighted(true);
                continue;
            }
            con.setColor(this.outColor);
            con.setHighlighted(true);
        }
    }

    private void connectionsfindNeurons() {
        int counter = 0;
        for (Connection connection : this.connections) {
            Connection con;
            long startneuronId = connection.getStartneuronId();
            long endneuronId = connection.getEndneuronId();
            int neuroncounter = 0;
            for (Neuron neuron : this.inputneurons) {
                if (startneuronId == neuron.getId()) {
                    con = this.connections.get(counter);
                    con.setStartNeuron(neuron);
                    this.connections.set(counter, con);
                    neuron.addToConnList(connection);
                }
                ++neuroncounter;
            }
            for (Neuron neuron : this.hiddenneurons) {
                if (startneuronId != neuron.getId()) continue;
                con = this.connections.get(counter);
                con.setStartNeuron(neuron);
                this.connections.set(counter, con);
                neuron.addToConnList(connection);
            }
            for (Neuron neuron : this.hiddenneurons) {
                if (endneuronId != neuron.getId()) continue;
                con = this.connections.get(counter);
                con.setEndNeuron(neuron);
                this.connections.set(counter, con);
                neuron.addToConnList(connection);
            }
            for (Neuron neuron : this.outputneurons) {
                if (endneuronId != neuron.getId()) continue;
                con = this.connections.get(counter);
                con.setEndNeuron(neuron);
                this.connections.set(counter, con);
                neuron.addToConnList(connection);
            }
            for (Neuron neuron : this.outputneurons) {
                if (startneuronId != neuron.getId()) continue;
                con = this.connections.get(counter);
                con.setStartNeuron(neuron);
                this.connections.set(counter, con);
                neuron.addToConnList(connection);
            }
            ++counter;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        int size;
        String id;
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.drawString("Hint: Click on a neuron to highlight it and get weight information", 22, 22);
        for (Connection connection : this.connections) {
            id = Long.toString(connection.getId());
            String weight = Double.toString(connection.getWeight());
            String formatedWeight = new DecimalFormat("##.##").format(connection.getWeight());
            int startX = connection.getStartNeuron().getCenterX();
            int startY = connection.getStartNeuron().getCenterY();
            int endX = connection.getEndNeuron().getCenterX();
            int endY = connection.getEndNeuron().getCenterY();
            int centerX = (endX - startX) / 2;
            int centerY = (endY - startY) / 2;
            Color color = connection.getColor();
            centerX = startX < endX ? startX + (endX - startX) / 2 : endX + (startX - endX) / 2;
            centerY = startY < endY ? startY + (endY - startY) / 2 : endY + (startY - endY) / 2;
            g2.setColor(color);
            g2.setStroke(new BasicStroke(1.0f));
            g2.drawLine(startX, startY, endX, endY);
        }
        this.drawHighlightedConnections(g2);
        for (Neuron neuron : this.inputneurons) {
            id = Long.toString(neuron.getId());
            int x = neuron.getX();
            int y = neuron.getY();
            int size2 = neuron.getSize();
            Color color = neuron.getColor();
            g2.setColor(Color.white);
            g2.fillRect(x, y, size2, size2);
            g2.setColor(color);
            g2.drawRect(x, y, size2, size2);
            if (neuron.isHighlighted()) {
                g2.setFont(new Font("default", 1, 12));
                g2.drawString(id, x + 2, y + 13);
                g2.setFont(new Font("default", 0, 12));
                continue;
            }
            g2.drawString(id, x + 2, y + 13);
        }
        for (Neuron neuron : this.hiddenneurons) {
            id = Long.toString(neuron.getId());
            int x = neuron.getX();
            int y = neuron.getY();
            Color color = neuron.getColor();
            size = neuron.getSize();
            g2.setColor(Color.white);
            g2.fillOval(x, y, size, size);
            g2.setColor(color);
            g2.drawOval(x, y, size, size);
            if (neuron.isHighlighted()) {
                g2.setFont(new Font("default", 1, 12));
                g2.drawString(id, x, y + 32);
                g2.setFont(new Font("default", 0, 12));
                continue;
            }
            g2.drawString(id, x, y + 32);
        }
        for (Neuron neuron : this.outputneurons) {
            id = Long.toString(neuron.getId());
            int x = neuron.getX();
            int y = neuron.getY();
            Color color = neuron.getColor();
            size = neuron.getSize();
            int[] xPoints = new int[]{x, x + size / 2, x + size};
            int[] yPoints = new int[]{y + size, y + 0, y + size};
            int nPoints = 3;
            g2.setColor(Color.white);
            g2.fillPolygon(xPoints, yPoints, nPoints);
            g2.setColor(color);
            g2.drawPolygon(xPoints, yPoints, nPoints);
            String outputAction = "";
            if ("152".equals(id)) {
                outputAction = "Move North";
            } else if ("153".equals(id)) {
                outputAction = "Accelerate";
            } else if ("154".equals(id)) {
                outputAction = "Move South";
            } else if ("155".equals(id)) {
                outputAction = "Decelerate";
            }
            if (neuron.isHighlighted()) {
                g2.setFont(new Font("default", 1, 12));
                g2.drawString(String.valueOf(id) + ": " + outputAction, x, y + 32);
                g2.setFont(new Font("default", 0, 12));
                continue;
            }
            g2.drawString(String.valueOf(id) + ": " + outputAction, x, y + 32);
        }
    }

    private void drawHighlightedConnections(Graphics2D g2) {
        for (Connection connection : this.connections) {
            if (!connection.isHighlighted()) continue;
            Color color = connection.getColor();
            int startX = connection.getStartNeuron().getCenterX();
            int startY = connection.getStartNeuron().getCenterY();
            int endX = connection.getEndNeuron().getCenterX();
            int endY = connection.getEndNeuron().getCenterY();
            int centerX = (endX - startX) / 2;
            int centerY = (endY - startY) / 2;
            g2.setColor(color);
            g2.setStroke(new BasicStroke(1.0f));
            g2.drawLine(startX, startY, endX, endY);
        }
        for (Connection connection : this.connections) {
            if (!connection.isHighlighted()) continue;
            int startX = connection.getStartNeuron().getCenterX();
            int startY = connection.getStartNeuron().getCenterY();
            int endX = connection.getEndNeuron().getCenterX();
            int endY = connection.getEndNeuron().getCenterY();
            int centerX = (endX - startX) / 2;
            int centerY = (endY - startY) / 2;
            centerX = startX < endX ? startX + (endX - startX) / 2 : endX + (startX - endX) / 2;
            centerY = startY < endY ? startY + (endY - startY) / 2 : endY + (startY - endY) / 2;
            Color color = connection.getColor();
            String formatedWeight = new DecimalFormat("##.##").format(connection.getWeight());
            g2.setColor(color.darker());
            g2.setFont(new Font("default", 1, 12));
            g2.drawString("w: " + formatedWeight, centerX, centerY - 11);
            g2.setFont(new Font("default", 0, 12));
        }
    }
}

