/*
 * Decompiled with CFR 0.152.
 */
package uni.hro.main;

import com.sun.istack.internal.NotNull;
import de.mein.auth.data.MeinAuthSettings;
import de.mein.auth.data.MeinRequest;
import de.mein.auth.data.access.CertificateManager;
import de.mein.auth.data.db.Certificate;
import de.mein.auth.data.db.ServiceJoinServiceType;
import de.mein.auth.service.MeinAuthService;
import de.mein.auth.service.MeinBoot;
import de.mein.auth.socket.process.reg.IRegisterHandler;
import de.mein.auth.socket.process.reg.IRegisterHandlerListener;
import de.mein.auth.socket.process.reg.IRegisteredHandler;
import de.mein.auth.tools.N;
import de.mein.auth.tools.WaitLock;
import java.io.File;
import java.util.List;
import uni.hro.networking.service.AquaBootLoader;
import uni.hro.networking.service.AquaService;

public abstract class Aqua<T extends AquaService> {
    private final int portCert;
    private final String name;
    private final int port;
    private final File directory;
    protected AquaService aquaService;
    private MeinAuthService meinAuthService;

    public T getAquaService() {
        return (T)this.aquaService;
    }

    public MeinAuthService getMeinAuthService() {
        return this.meinAuthService;
    }

    public Aqua(@NotNull File directory, @NotNull String name, @NotNull int port, @NotNull int portCert) {
        this.port = port;
        this.portCert = portCert;
        this.name = name;
        this.directory = directory;
    }

    public MeinAuthService startAqua() throws Exception {
        CertificateManager.deleteDirectory(this.directory);
        MeinBoot.addBootLoaderClass(AquaBootLoader.class);
        IRegisterHandler allowRegisterHandler = new IRegisterHandler(){

            @Override
            public void acceptCertificate(IRegisterHandlerListener listener, MeinRequest request, Certificate myCertificate, Certificate certificate) {
                listener.onCertificateAccepted(request, certificate);
            }

            @Override
            public void onRegistrationCompleted(Certificate partnerCertificate) {
            }
        };
        IRegisteredHandler registeredHandler = (meinAuthService, registered) -> {
            List<ServiceJoinServiceType> services = meinAuthService.getDatabaseManager().getAllServices();
            for (ServiceJoinServiceType serviceJoinServiceType : services) {
                meinAuthService.getDatabaseManager().grant(serviceJoinServiceType.getServiceId().v(), registered.getId().v());
            }
        };
        MeinAuthSettings settings = new MeinAuthSettings().setPort(this.port).setDeliveryPort(this.portCert).setBrotcastListenerPort(9966).setBrotcastPort(9966).setWorkingDirectory(this.directory).setName("MA1").setGreeting("greeting1");
        WaitLock waitLock = new WaitLock().lock();
        MeinBoot meinBoot = new MeinBoot(settings);
        meinBoot.boot().done(ma1 -> N.r(() -> {
            this.meinAuthService = ma1;
            this.meinAuthService.addRegisteredHandler(registeredHandler);
            this.meinAuthService.addRegisterHandler(allowRegisterHandler);
            System.out.println("AquaServer.main.server.is.up");
            AquaBootLoader aquaBootLoader = (AquaBootLoader)MeinBoot.getBootLoader(this.meinAuthService, new AquaBootLoader().getName());
            this.aquaService = this.isServer() ? aquaBootLoader.newServerService(this.name) : aquaBootLoader.newClientService(this.name);
            waitLock.unlock();
        })).fail(Throwable::printStackTrace);
        waitLock.lock();
        return this.meinAuthService;
    }

    abstract boolean isServer();
}

