/*
 * Decompiled with CFR 0.152.
 */
package uni.hro.model;

import com.anji.integration.Activator;
import com.anji.integration.ActivatorTranscriber;
import com.anji.integration.TranscriberException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgap.Chromosome;
import uni.hro.model.Consumable;
import uni.hro.model.Fish;
import uni.hro.model.Food;
import uni.hro.model.HitBox;
import uni.hro.model.HitBoxInputValueGenerator;
import uni.hro.model.IntegerPoint;
import uni.hro.model.Kraken;
import uni.hro.model.OutOfBounds;
import uni.hro.model.Point;
import uni.hro.model.World;
import uni.hro.model.WorldEntity;
import uni.hro.model.valuegenerators.FishHitBoxInputValueGenerator;
import uni.hro.model.valuegenerators.FoodHitBoxInputValueGenerator;
import uni.hro.model.valuegenerators.KrakenHitBoxInputValueGenerator;
import uni.hro.model.valuegenerators.OutOfBoundsValueGenerator;

public abstract class Creature
extends Consumable {
    protected float fuel;
    protected World world;
    protected Map<HitBox, Point<Integer>> hitboxes = new HashMap<HitBox, Point<Integer>>();
    protected List<HitBox> hitBoxes = new ArrayList<HitBox>();
    protected boolean looksLeft = false;
    protected List<HitBoxInputValueGenerator> inputValueGenerators = new ArrayList<HitBoxInputValueGenerator>();
    protected Set<WorldEntity> collidedEntities = new HashSet<WorldEntity>();
    private Chromosome chromosome;
    private double speed;
    private int age = 0;
    protected boolean hasInputValueGenerators;
    private int ageAtDeath = 0;
    private boolean isHidden = false;
    private Integer inputArraySize;
    private Activator activator;

    protected void createNeuron(int offsetX, int offsetY) {
        IntegerPoint point = new IntegerPoint(offsetX, offsetY);
        HitBox neuron = new HitBox(this, point);
        this.hitboxes.put(neuron, point);
        this.hitBoxes.add(neuron);
    }

    public Chromosome getChromosome() {
        return this.chromosome;
    }

    protected Creature() {
    }

    public boolean isAlive() {
        return this.fuel > 0.0f;
    }

    public boolean looksLeft() {
        return this.looksLeft;
    }

    public void setLooksLeft(boolean looksLeft) {
        this.looksLeft = looksLeft;
    }

    public Creature(World world, float fuel, float x, float y, float width, float height) {
        super(x, y, width, height);
        this.world = world;
        this.fuel = fuel;
        this.speed = 0.5;
    }

    public synchronized void addFuel(float amount) {
        this.fuel += amount;
    }

    public void swim() {
        this.fuel = this.fuel - 0.06f - (Math.abs(this.vx) + Math.abs(this.vy)) / 150.0f;
        if (this.fuel < 0.0f) {
            this.fuel = 0.0f;
            this.die();
        }
        this.vx += this.dx;
        this.vy += this.dy;
        this.vx = (float)((double)this.vx * 0.75);
        this.vy = (float)((double)this.vy * 0.75);
        this.looksLeft = this.vx < 0.0f;
        this.checkWorldCollision(this.world.getWidth() - 30, this.world.getHeight() - 50);
        this.x += this.vx;
        this.y += this.vy;
        this.dx = 0.0f;
        this.dy = 0.0f;
    }

    public void sink() {
        this.vx *= 0.3f;
        this.vy = 1.0f;
        this.swim();
    }

    private boolean doesItCut(float neuronTopY, float neuronBottomY, float neuronLeftX, float neuronRightX, float topY, float bottomY, float leftX, float rightX) {
        boolean isEnclosing;
        boolean isEnclosed = topY <= neuronTopY && bottomY >= neuronBottomY && leftX <= neuronLeftX && rightX >= neuronRightX;
        boolean bl = isEnclosing = topY >= neuronTopY && bottomY <= neuronBottomY && leftX >= neuronLeftX && rightX <= neuronRightX;
        if (isEnclosed || isEnclosing) {
            return true;
        }
        int cuts = 0;
        if (this.inBetween(topY, neuronBottomY, neuronTopY) && (cuts += this.cut1(leftX, rightX, neuronRightX, neuronLeftX)) > 1) {
            return true;
        }
        if (this.inBetween(bottomY, neuronBottomY, neuronTopY) && (cuts += this.cut1(leftX, rightX, neuronRightX, neuronLeftX)) > 1) {
            return true;
        }
        if (this.inBetween(leftX, neuronRightX, neuronLeftX) && (cuts += this.cut1(topY, bottomY, neuronBottomY, neuronTopY)) > 1) {
            return true;
        }
        return this.inBetween(rightX, neuronRightX, neuronLeftX) && (cuts += this.cut1(topY, bottomY, neuronBottomY, neuronTopY)) > 1;
    }

    public void perceive() {
        for (HitBox hitBox : this.hitBoxes) {
            hitBox.clear();
        }
        this.collidedEntities = new HashSet<WorldEntity>();
        float top = this.getTopY();
        float bottom = this.getBottomY();
        float left = this.getLeftX();
        float right = this.getRightX();
        for (WorldEntity entity : this.world.getEntities()) {
            float eRight;
            float eLeft;
            float eBottom;
            if (entity == this) continue;
            float eTop = entity.getTopY();
            boolean collided = this.doesItCut(top, bottom, left, right, eTop, eBottom = entity.getBottomY(), eLeft = entity.getLeftX(), eRight = entity.getRightX());
            if (collided) {
                this.collidedEntities.add(entity);
            }
            for (HitBox hitBox : this.hitBoxes) {
                float neuronRightX;
                float neuronLeftX;
                float neuronBottomY;
                float neuronTopY = hitBox.getTopY();
                boolean cuts = this.doesItCut(neuronTopY, neuronBottomY = (float)hitBox.getBottomY(), neuronLeftX = (float)hitBox.getLeftX(), neuronRightX = (float)hitBox.getRightX(), eTop, eBottom, eLeft, eRight);
                if (cuts) {
                    hitBox.addPerceivedEntity(entity);
                }
                if (!(neuronTopY < 0.0f || neuronBottomY > (float)this.world.getHeight() || neuronLeftX < 0.0f) && !(neuronRightX > (float)this.world.getWidth())) continue;
                hitBox.addPerceivedEntity(new OutOfBounds());
            }
        }
    }

    private int cut1(float entityLeftX, float entityRightX, float neuronRightX, float neuronLeftX) {
        int cuts = 0;
        if (this.inBetween(entityLeftX, neuronRightX, neuronLeftX)) {
            ++cuts;
        }
        if (this.inBetween(entityRightX, neuronRightX, neuronLeftX)) {
            ++cuts;
        }
        return cuts;
    }

    private boolean inBetween(float value, float upperBound, float lowerBound) {
        return value < upperBound && value > lowerBound;
    }

    public void moveN(double factor) {
        this.dy = (float)((double)this.dy + -this.speed * factor);
        this.checkWorldCollision(this.world.getWidth(), this.world.getHeight());
    }

    public void accelerate(double factor) {
        this.dx = (float)((double)this.dx + (this.looksLeft ? this.speed * factor * -1.0 : this.speed * factor));
        this.checkWorldCollision(this.world.getWidth(), this.world.getHeight());
    }

    public void moveS(double factor) {
        this.dy = (float)((double)this.dy + this.speed * factor);
        this.checkWorldCollision(this.world.getWidth(), this.world.getHeight());
    }

    public void decelerate(double factor) {
        this.dx = (float)((double)this.dx + (this.looksLeft ? this.speed * factor : this.speed * factor * -1.0));
        this.checkWorldCollision(this.world.getWidth(), this.world.getHeight());
    }

    public Creature createInputValueGenerators() {
        if (!this.hasInputValueGenerators) {
            this.hitboxes.forEach((inputNeuron, integerPoint) -> {
                this.inputValueGenerators.add(new KrakenHitBoxInputValueGenerator((HitBox)inputNeuron, Kraken.class));
                this.inputValueGenerators.add(new FishHitBoxInputValueGenerator((HitBox)inputNeuron, Fish.class));
                this.inputValueGenerators.add(new FoodHitBoxInputValueGenerator((HitBox)inputNeuron, Food.class));
                this.inputValueGenerators.add(new OutOfBoundsValueGenerator((HitBox)inputNeuron, OutOfBounds.class));
            });
            this.hasInputValueGenerators = true;
        }
        return this;
    }

    public List<HitBoxInputValueGenerator> getInputValueGenerators() {
        return this.inputValueGenerators;
    }

    public Map<HitBox, Point<Integer>> getHitboxes() {
        return this.hitboxes;
    }

    public void setFitnessValue(int age) {
        this.ageAtDeath = age;
        this.chromosome.setFitnessValue(age);
    }

    public int getFitnessValue() {
        return this.ageAtDeath;
    }

    public void setChromosome(Chromosome chromosome) {
        this.chromosome = chromosome;
        this.activator = null;
    }

    public abstract void handleCollisions();

    public void age() {
        ++this.age;
    }

    public void onDeath() {
        this.chromosome.setFitnessValue(this.age);
    }

    public void setFuel(float fuel) {
        this.fuel = fuel;
    }

    public void reset() {
        this.fuel = 100.0f;
        this.consumed = false;
    }

    public int getAge() {
        return this.age;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public void setHidden(boolean isHidden) {
        this.isHidden = isHidden;
    }

    public static Integer calcInputSize(Creature creature) {
        return creature.getInputValueGenerators().size();
    }

    public double[] createInputArray() {
        if (this.inputArraySize == null) {
            this.inputArraySize = Creature.calcInputSize(this);
        }
        return new double[this.inputArraySize.intValue()];
    }

    public Activator getActivator(ActivatorTranscriber factory) throws TranscriberException {
        if (this.activator == null) {
            this.activator = factory.newActivator(this.chromosome);
        }
        return this.activator;
    }

    protected void die() {
        this.chromosome.setFitnessValue(this.calculateFitnessValue());
    }

    protected abstract int calculateFitnessValue();

    public String toString() {
        return "id: " + this.chromosome.getId().toString();
    }
}

