/*
 * Decompiled with CFR 0.152.
 */
package uni.hro.model;

import uni.hro.model.Creature;
import uni.hro.model.Food;
import uni.hro.model.World;
import uni.hro.model.WorldEntity;

public class Fish
extends Creature {
    private int timesConsumed = 0;
    private boolean wasEaten = false;

    public Fish(World world, float x, float y) {
        super(world, 100.0f, x, y, 30.0f, 13.0f);
        this.createNeuron(1, 0);
        this.createNeuron(1, 1);
        this.createNeuron(1, -1);
        this.createNeuron(2, 0);
        this.createNeuron(2, 1);
        this.createNeuron(2, 2);
        this.createNeuron(2, -1);
        this.createNeuron(2, -2);
        this.createNeuron(3, 0);
        this.createNeuron(3, 1);
        this.createNeuron(3, 2);
        this.createNeuron(3, 3);
        this.createNeuron(3, -1);
        this.createNeuron(3, -2);
        this.createNeuron(3, -3);
        this.createNeuron(4, 0);
        this.createNeuron(4, 1);
        this.createNeuron(4, 2);
        this.createNeuron(4, 3);
        this.createNeuron(4, 4);
        this.createNeuron(4, -1);
        this.createNeuron(4, -2);
        this.createNeuron(4, -3);
        this.createNeuron(4, -4);
        this.createNeuron(5, 0);
        this.createNeuron(5, 1);
        this.createNeuron(5, 2);
        this.createNeuron(5, 3);
        this.createNeuron(5, 4);
        this.createNeuron(5, -1);
        this.createNeuron(5, -2);
        this.createNeuron(5, -3);
        this.createNeuron(5, -4);
        this.createNeuron(0, 1);
        this.createNeuron(0, -1);
        this.createNeuron(-1, 0);
        this.createNeuron(-1, -1);
        this.createNeuron(-1, 1);
        this.createInputValueGenerators();
    }

    public static Integer calcInputSize() {
        Fish fish = new Fish(new World(1, 1), 1.0f, 1.0f);
        return Creature.calcInputSize(fish);
    }

    public Fish() {
    }

    @Override
    public void handleCollisions() {
        for (WorldEntity worldEntity : this.collidedEntities) {
            if (!(worldEntity instanceof Food)) continue;
            Food food = (Food)worldEntity;
            Float consumed = Float.valueOf(food.consume());
            this.addFuel(consumed.floatValue());
        }
    }

    @Override
    public int calculateFitnessValue() {
        int f = this.getAge() + this.timesConsumed * 1000;
        if (this.wasEaten) {
            f -= 500;
        }
        return f;
    }

    public int getTimesConsumed() {
        return this.timesConsumed;
    }

    @Override
    public synchronized float consume() {
        if (!this.consumed) {
            this.consumed = true;
            if (this.isAlive()) {
                this.die();
                return this.fuel;
            }
            return 25.0f;
        }
        this.fuel = 0.0f;
        return 0.0f;
    }
}

