/*
 * Decompiled with CFR 0.152.
 */
package uni.hro.model;

import java.util.Random;
import uni.hro.model.Consumable;
import uni.hro.model.World;

public class Food
extends Consumable {
    protected World world;
    private double sinkspeed;
    private float fuel = 100.0f;

    public Food(World world, float x, float y) {
        super(x, y, 2.0f, 2.0f);
        this.world = world;
        this.sinkspeed = (double)Food.generateRandom(1, 2) / 10.0;
    }

    @Override
    public synchronized float consume() {
        if (!this.consumed) {
            this.consumed = true;
            return this.fuel;
        }
        return 0.0f;
    }

    public boolean sink() {
        this.dy = (float)this.sinkspeed;
        this.y += this.dy;
        return !(this.y > (float)this.world.getHeight());
    }

    public synchronized float emptyFuel() {
        float result2 = this.fuel;
        this.fuel = 0.0f;
        return result2;
    }

    public static int generateRandom(int min, int max) {
        Random rn = new Random();
        int randomvalue = rn.nextInt(max - min + 1) + min;
        return randomvalue;
    }
}

